/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.BrowserHelper;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.DialogWithButtons;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;

public class HelpDialog
extends DialogWithButtons {
    private static final long serialVersionUID = 8716599240055591957L;
    protected JEditorPane m_TextArea;
    protected JButton m_ButtonClose;

    public HelpDialog(Dialog parent) {
        super(parent);
    }

    public HelpDialog(Frame parent) {
        super(parent);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle("Help");
        this.m_TextArea = new JEditorPane();
        this.m_TextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextArea.setEditable(false);
        this.m_TextArea.setFont(GUIHelper.getMonospacedFont());
        this.m_TextArea.setAutoscrolls(true);
        this.m_TextArea.addHyperlinkListener(new BrowserHelper.DefaultHyperlinkListener());
        this.m_TextArea.addKeyListener(this.getKeyListener());
        this.getContentPane().add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        this.m_ButtonClose = new JButton("Close");
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addKeyListener(this.getKeyListener());
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.close();
            }
        });
        this.m_PanelButtonsRight.add(this.m_ButtonClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HelpDialog.this.close();
            }
        });
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.pack();
        this.m_ButtonClose.requestFocusInWindow();
    }

    protected KeyListener getKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 87 && e.isControlDown() && !e.isAltDown() && !e.isShiftDown()) {
                    e.consume();
                    HelpDialog.this.close();
                } else {
                    super.keyPressed(e);
                }
            }
        };
    }

    protected void close() {
        this.dispose();
    }

    public void setHelp(String value, boolean isHtml) {
        if (isHtml) {
            this.m_TextArea.setContentType("text/html");
        } else {
            this.m_TextArea.setContentType("text/plain");
        }
        this.m_TextArea.setText(value);
        this.m_TextArea.setCaretPosition(0);
    }
}

