/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.menu;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.menu.AbstractFlowEditorMenuItemAction;
import java.awt.event.ActionEvent;

public class ExecutionValidateSetup
extends AbstractFlowEditorMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;

    @Override
    protected String getTitle() {
        return "Validate setup";
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        String msg = null;
        StringBuilder errors = new StringBuilder();
        AbstractActor actor = ((FlowEditorPanel)this.m_State).getCurrentFlow(errors);
        if (errors.length() > 0) {
            msg = errors.toString();
        }
        if (msg == null) {
            try {
                msg = actor.setUp();
                actor.wrapUp();
                actor.cleanUp();
            }
            catch (Exception ex) {
                msg = "Actor generated exception: ";
                System.err.println(msg);
                ex.printStackTrace();
                msg = msg + e;
            }
        }
        if (msg == null) {
            msg = ActorUtils.checkFlow(actor);
        }
        if (msg == null) {
            msg = "The flow passed validation!";
            ((FlowEditorPanel)this.m_State).getCurrentPanel().showStatus(msg);
            ((FlowEditorPanel)this.m_State).getCurrentPanel().showNotification(msg, false);
        } else {
            ((FlowEditorPanel)this.m_State).getCurrentPanel().showStatus(msg);
            ((FlowEditorPanel)this.m_State).getCurrentPanel().showNotification("The flow setup failed validation:\n" + msg, true);
        }
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((FlowEditorPanel)this.m_State).hasCurrentPanel() && this.isInputEnabled());
    }
}

