/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorWithConditionalEquivalent;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class MakeConditional
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Make conditional...";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).isSingleSel && ((StateContainer)this.m_State).tree.getOwner() != null && ((StateContainer)this.m_State).selNode.getActor() instanceof ActorWithConditionalEquivalent);
    }

    protected void makeConditional(TreePath path) {
        Node currNode = TreeHelper.pathToNode(path);
        Node parentNode = (Node)currNode.getParent();
        boolean expanded = ((StateContainer)this.m_State).tree.isExpanded(path);
        AbstractActor currActor = currNode.getFullActor().shallowCopy();
        boolean noEquiv = false;
        Class condEquiv = null;
        if (!(currActor instanceof ActorWithConditionalEquivalent)) {
            noEquiv = true;
        }
        if (!noEquiv && (condEquiv = ((ActorWithConditionalEquivalent)((Object)currActor)).getConditionalEquivalent()) == null) {
            noEquiv = true;
        }
        if (noEquiv) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Actor '" + currActor.getClass().getName() + "' does not have a conditional equivalent!");
            return;
        }
        Node newNode = null;
        AbstractActor newActor = null;
        try {
            newActor = (AbstractActor)condEquiv.newInstance();
            newActor.setAnnotations(currActor.getAnnotations());
            newActor.setSkip(currActor.getSkip());
            newActor.setLoggingLevel(currActor.getLoggingLevel());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to instantiate conditional equivalent: " + condEquiv.getName());
            return;
        }
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog()) : new GenericObjectEditorDialog(this.getParentFrame());
        dialog.setTitle("Conditions");
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(BooleanCondition.class);
        dialog.setCurrent(new Expression());
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        ((BooleanConditionSupporter)((Object)newActor)).setCondition((BooleanCondition)dialog.getCurrent());
        newNode = new Node(((StateContainer)this.m_State).tree, newActor);
        this.addUndoPoint("Making conditional actor from '" + currNode.getActor().getFullName());
        for (BaseTreeNode child : currNode.getChildren()) {
            newNode.add(child);
        }
        boolean defaultName = currActor.getName().equals(currActor.getDefaultName());
        int index = parentNode.getIndex(currNode);
        parentNode.insert(newNode, index);
        parentNode.remove(currNode);
        if (!defaultName) {
            newActor.setName(currActor.getName());
            newNode.setActor(newActor);
            ((StateContainer)this.m_State).tree.updateActorName(newNode);
        }
        if (expanded) {
            ((StateContainer)this.m_State).tree.expand(newNode);
        }
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.nodeStructureChanged(parentNode);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, parentNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.nodeStructureChanged(parentNode);
        ((StateContainer)this.m_State).tree.locateAndDisplay(newNode.getFullName());
        ((StateContainer)this.m_State).tree.redraw();
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.makeConditional(((StateContainer)this.m_State).selPath);
    }
}

