/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.AdditionalInformationHandler;
import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.option.AbstractOption;
import adams.gui.core.AbstractAdvancedScript;
import adams.gui.core.AbstractSimpleScript;
import adams.gui.core.AbstractTextAreaPanelWithAdvancedSyntaxHighlighting;
import adams.gui.core.DefaultTextAreaPanelWithAdvancedSyntaxHighlighting;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class AbstractAdvancedScriptEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport {
    protected AbstractTextAreaPanelWithAdvancedSyntaxHighlighting m_TextStatement;

    public static String toString(AbstractOption option, Object object) {
        return ((AbstractAdvancedScript)object).stringValue();
    }

    public static Object valueOf(Class cls, String str) {
        AbstractAdvancedScript result;
        try {
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            result = (AbstractAdvancedScript)cls.newInstance();
            result.setValue(Utils.unbackQuoteChars(str));
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object valueOf(AbstractOption option, String str) {
        return AbstractAdvancedScriptEditor.valueOf(option.getDefaultValue().getClass(), str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return AbstractAdvancedScriptEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return AbstractAdvancedScriptEditor.valueOf(this.getValue().getClass(), str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + AbstractAdvancedScriptEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : AbstractAdvancedScriptEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected Dimension getDefaultSize() {
        return new Dimension(600, 500);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setSize(this.getDefaultSize());
        panelAll.setMinimumSize(this.getDefaultSize());
        panelAll.setPreferredSize(this.getDefaultSize());
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextStatement = this.getValue() == null ? new DefaultTextAreaPanelWithAdvancedSyntaxHighlighting() : ((AbstractAdvancedScript)this.getValue()).getTextAreaPanel();
        panelAll.add((Component)this.m_TextStatement, "Center");
        JPanel panelBottom = new JPanel(new BorderLayout());
        panelAll.add((Component)panelBottom, "South");
        JPanel panelButtonsLeft = new JPanel(new FlowLayout(0));
        panelBottom.add((Component)panelButtonsLeft, "West");
        final JButton buttonOptions = new JButton("...");
        buttonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = AbstractAdvancedScriptEditor.this.createPopupMenu();
                menu.show(buttonOptions, 0, buttonOptions.getHeight());
            }
        });
        panelButtonsLeft.add(buttonOptions);
        JPanel panelButtonsRight = new JPanel(new FlowLayout(2));
        panelBottom.add((Component)panelButtonsRight, "East");
        if (this.m_TextStatement instanceof AdditionalInformationHandler) {
            JButton buttonHelp = new JButton("Help");
            buttonHelp.setMnemonic('H');
            buttonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String help = ((AdditionalInformationHandler)((Object)AbstractAdvancedScriptEditor.this.m_TextStatement)).getAdditionalInformation();
                    TextDialog dlg = new TextDialog();
                    dlg.setDefaultCloseOperation(2);
                    dlg.setDialogTitle("Help");
                    dlg.setContent(help);
                    dlg.setLineWrap(true);
                    dlg.setEditable(false);
                    dlg.setVisible(true);
                }
            });
            panelButtonsRight.add(buttonHelp);
        }
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = AbstractAdvancedScriptEditor.this.m_TextStatement.getContent();
                if (((AbstractSimpleScript)AbstractAdvancedScriptEditor.this.getValue()).isValid(s) && !s.equals(((AbstractSimpleScript)AbstractAdvancedScriptEditor.this.getValue()).getValue())) {
                    try {
                        AbstractSimpleScript newValue = (AbstractSimpleScript)AbstractAdvancedScriptEditor.this.getValue().getClass().newInstance();
                        newValue.setValue(s);
                        AbstractAdvancedScriptEditor.this.setValue(newValue);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to create AbstractScript-derived object from '" + s + "':");
                        ex.printStackTrace();
                    }
                }
                AbstractAdvancedScriptEditor.this.closeDialog(1);
            }
        });
        panelButtonsRight.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.closeDialog(0);
            }
        });
        panelButtonsRight.add(buttonClose);
        return panelAll;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Cut");
        menuitem.setIcon(GUIHelper.getIcon("cut.gif"));
        menuitem.setEnabled(this.m_TextStatement.canCut());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.cut();
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.m_TextStatement.canCopy());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.copy();
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Paste");
        menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
        menuitem.setEnabled(this.m_TextStatement.canPaste());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.paste();
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Undo");
        menuitem.setIcon(GUIHelper.getIcon("undo.gif"));
        menuitem.setEnabled(this.m_TextStatement.canUndo());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.undo();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        menuitem = new JMenuItem("Redo");
        menuitem.setIcon(GUIHelper.getIcon("redo.gif"));
        menuitem.setEnabled(this.m_TextStatement.canRedo());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.redo();
            }
        });
        result.add(menuitem);
        menuitem = new JCheckBoxMenuItem("Line wrap");
        menuitem.setIcon(GUIHelper.getIcon("linewrap.png"));
        menuitem.setSelected(this.m_TextStatement.getLineWrap());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAdvancedScriptEditor.this.m_TextStatement.setLineWrap(((JMenuItem)e.getSource()).isSelected());
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.addAdditionalMenuItems(result);
        return result;
    }

    protected void addAdditionalMenuItems(JPopupMenu menu) {
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextStatement.getContent().equals("" + this.getValue())) {
            this.m_TextStatement.setContent("" + this.getValue());
        }
        this.m_TextStatement.setToolTipText(((BaseObject)this.getValue()).getTipText());
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(AbstractAdvancedScriptEditor.valueOf(this.getValue().getClass(), value));
        }
    }

    @Override
    public String getInlineValue() {
        return Utils.backQuoteChars(((BaseObject)this.getValue()).getValue());
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return ((BaseObject)this.getValue()).isValid(Utils.unbackQuoteChars(value));
    }
}

