/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHandler;
import adams.flow.core.ExternalActorHandler;
import adams.flow.standalone.AbstractDatabaseConnection;
import adams.flow.standalone.Standalones;
import adams.gui.application.Child;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class FlowHelper {
    public static Tree getTree(Container cont) {
        Tree result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            Component comp = null;
            if (parent instanceof Child) {
                comp = parent instanceof ChildFrame ? ((ChildFrame)parent).getContentPane().getComponent(0) : ((ChildWindow)parent).getContentPane().getComponent(0);
            } else if (parent instanceof FlowEditorPanel) {
                comp = parent;
            }
            if (comp != null && comp instanceof FlowEditorPanel) {
                FlowEditorPanel editor = (FlowEditorPanel)comp;
                if (!editor.hasCurrentPanel()) break;
                result = editor.getCurrentPanel().getTree();
                break;
            }
            if (!(parent instanceof Container)) break;
        }
        return result;
    }

    public static boolean isFlowEdited(Container cont) {
        return FlowHelper.getTree(cont) != null;
    }

    public static Node getEditedNode(Container cont) {
        Node result = null;
        Tree tree = FlowHelper.getTree(cont);
        if (tree != null) {
            result = tree.getCurrentEditingNode();
        }
        return result;
    }

    public static Node getEditedParent(Container cont) {
        Node result = null;
        Tree tree = FlowHelper.getTree(cont);
        if (tree != null) {
            result = tree.getCurrentEditingParent();
        }
        return result;
    }

    public static adams.db.AbstractDatabaseConnection getDatabaseConnection(Container cont, Class actorCls, adams.db.AbstractDatabaseConnection defDbCon) {
        adams.db.AbstractDatabaseConnection result = null;
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        if (parent == null) {
            return result;
        }
        return FlowHelper.getDatabaseConnection(parent, actorCls, defDbCon);
    }

    public static adams.db.AbstractDatabaseConnection getDatabaseConnection(Node parent, Class actorCls, adams.db.AbstractDatabaseConnection defDbCon) {
        return FlowHelper.getDatabaseConnection(parent, actorCls, defDbCon, true);
    }

    protected static adams.db.AbstractDatabaseConnection getDatabaseConnection(Node parent, Class actorCls, adams.db.AbstractDatabaseConnection defDbCon, boolean up) {
        adams.db.AbstractDatabaseConnection result = null;
        while (parent != null && result == null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
                Node current;
                AbstractActor actor;
                block1: for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                    int n;
                    if (!actor.getSkip() && actor.getClass().isAssignableFrom(actorCls)) {
                        result = ((AbstractDatabaseConnection)actor).getConnection();
                        break;
                    }
                    if (actor instanceof Standalones) {
                        for (n = 0; n < current.getChildCount(); ++n) {
                            AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                            if (subactor.getSkip() || !subactor.getClass().isAssignableFrom(actorCls)) continue;
                            result = ((AbstractDatabaseConnection)subactor).getConnection();
                            continue block1;
                        }
                        continue;
                    }
                    if (!(actor instanceof ExternalActorHandler)) continue;
                    current.expand();
                    for (n = 0; n < current.getChildCount() && (result = FlowHelper.getDatabaseConnection((Node)current.getChildAt(n), actorCls, defDbCon, false)) == null; ++n) {
                    }
                }
            }
            if (up) {
                parent = (Node)parent.getParent();
                continue;
            }
            parent = null;
        }
        if (result == null) {
            result = defDbCon;
        }
        return result;
    }

    public static List<Node> findCallableActorsHandler(Container cont) {
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        return FlowHelper.findCallableActorsHandler(current, parent);
    }

    public static List<Node> findCallableActorsHandler(Node current, Node parent) {
        return FlowHelper.findCallableActorsHandler(current, parent, true, null);
    }

    public static List<Node> findCallableActorsHandler(Node current, Node parent, Class[] restrict) {
        return FlowHelper.findCallableActorsHandler(current, parent, true, new HashSet<Class>(Arrays.asList(restrict)));
    }

    protected static List<Node> findCallableActorsHandler(Node current, Node parent, boolean up, HashSet<Class> restrict) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (parent == null) {
            return result;
        }
        while (parent != null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
                AbstractActor actor;
                for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                    int n;
                    if (!actor.getSkip() && actor instanceof CallableActorHandler) {
                        if (restrict != null && (restrict == null || !restrict.contains(actor.getClass()))) continue;
                        result.add(current);
                        continue;
                    }
                    if (actor instanceof Standalones) {
                        for (n = 0; n < current.getChildCount(); ++n) {
                            AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                            if (subactor.getSkip() || !(subactor instanceof CallableActorHandler) || restrict != null && (restrict == null || !restrict.contains(subactor.getClass()))) continue;
                            result.add((Node)current.getChildAt(n));
                        }
                        continue;
                    }
                    if (!(actor instanceof ExternalActorHandler)) continue;
                    current.expand();
                    for (n = 0; n < current.getChildCount(); ++n) {
                        result.addAll(FlowHelper.findCallableActorsHandler(current, (Node)current.getChildAt(n), false, restrict));
                    }
                }
            }
            if (up) {
                parent = (Node)parent.getParent();
                continue;
            }
            parent = null;
        }
        return result;
    }

    public static List<Node> findTopCallableActors(Container cont) {
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        if (parent != null) {
            parent = (Node)parent.getRoot();
        }
        return FlowHelper.findTopCallableActors(parent);
    }

    public static List<Node> findTopCallableActors(Node parent) {
        ActorHandler handler;
        ArrayList<Node> result = new ArrayList<Node>();
        if (parent == null) {
            return result;
        }
        if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
            Node current;
            AbstractActor actor;
            for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                int n;
                if (!actor.getSkip() && actor instanceof CallableActorHandler) {
                    result.add(current);
                    continue;
                }
                if (actor instanceof Standalones) {
                    for (n = 0; n < current.getChildCount(); ++n) {
                        AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                        if (subactor.getSkip() || !(subactor instanceof CallableActorHandler)) continue;
                        result.add((Node)current.getChildAt(n));
                    }
                    continue;
                }
                if (!(actor instanceof ExternalActorHandler)) continue;
                current.expand();
                for (n = 0; n < current.getChildCount(); ++n) {
                    result.addAll(FlowHelper.findTopCallableActors((Node)current.getChildAt(n)));
                }
            }
        }
        return result;
    }
}

