/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Range;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.AbstractContainerManager;

public class RemoveData
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -4530704396431542201L;
    public static final String ACTION = "remove-data";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected String getOptionsDescription() {
        return "<comma-separated list of 1-based indices (or ranges of indices)>";
    }

    @Override
    public String getDescription() {
        return "Removes the data containers with the specified indices.\nNB: index is based on the order the data containers have beeen loaded into the system, includes all data containers, not just visible ones.";
    }

    @Override
    public String process(String options) throws Exception {
        this.addUndoPoint("Saving undo data...", "Remove container(s): " + options);
        Object manager = this.getDataContainerPanel().getContainerManager();
        Range range = new Range(options);
        range.setMax(((AbstractContainerManager)manager).count());
        int[] indices = range.getIntIndices();
        ((AbstractContainerManager)manager).startUpdate();
        for (int i = indices.length - 1; i >= 0; --i) {
            ((AbstractContainerManager)manager).remove(indices[i]);
        }
        ((AbstractContainerManager)manager).finishUpdate();
        return null;
    }
}

