/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.event.ScriptingEvent;
import adams.gui.event.ScriptingListener;
import adams.gui.scripting.ScriptingCommand;
import java.util.HashSet;
import java.util.Iterator;

public class ScriptingLogger {
    public static final String FILENAME = "ScriptingLogger.props";
    protected Properties m_Properties;
    protected PlaceholderFile m_LogFile;
    protected String m_LogFormat;
    protected HashSet<ScriptingListener> m_ScriptingListeners = new HashSet();
    protected static ScriptingLogger m_Singleton;

    private ScriptingLogger() {
        this.m_Properties = Environment.getInstance().read("scripting logger");
        if (!this.m_Properties.getBoolean("LogToFile", false).booleanValue()) {
            this.m_LogFile = null;
        } else {
            this.m_LogFile = new PlaceholderFile(this.m_Properties.getPath("LogFile", "%t/gcms_cmds.log"));
            this.m_LogFormat = this.m_Properties.getProperty("LogFormat", "SOURCE\tBASEPANEL\tSUCCESS\tCMD\tERROR");
        }
    }

    public synchronized void log(Object source, ScriptingCommand cmd, boolean success) {
        this.log(source, cmd, success, null);
    }

    public synchronized void log(Object source, ScriptingCommand cmd, boolean success, String error) {
        if (this.m_LogFile != null) {
            String line = this.m_LogFormat;
            line = line.replaceAll("SOURCE", source.getClass().getName() + "/" + source.hashCode());
            line = cmd.getBasePanel() == null ? line.replaceAll("BASEPANEL", "-no base panel-") : line.replaceAll("BASEPANEL", cmd.getBasePanel().getName());
            line = line.replaceAll("SUCCESS", "" + success);
            line = line.replaceAll("CMD", cmd.getCommand());
            line = error == null ? line.replaceAll("ERROR", "-no error msg-") : line.replaceAll("ERROR", error);
            FileUtils.writeToFile(this.m_LogFile.getAbsolutePath(), line);
        }
        this.notifyScriptingListeners(new ScriptingEvent(source, cmd, success, error));
    }

    public void addScriptingListener(ScriptingListener l) {
        this.m_ScriptingListeners.add(l);
    }

    public void removeScriptingListener(ScriptingListener l) {
        this.m_ScriptingListeners.remove(l);
    }

    protected synchronized void notifyScriptingListeners(ScriptingEvent e) {
        Iterator<ScriptingListener> iter = this.m_ScriptingListeners.iterator();
        while (iter.hasNext()) {
            iter.next().scriptingCommandExecuted(e);
        }
    }

    public static synchronized ScriptingLogger getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ScriptingLogger();
        }
        return m_Singleton;
    }
}

