/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.db.AbstractConditions;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.db.LogEntry;
import adams.db.LogEntryConditions;
import adams.db.LogT;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.core.PropertiesTableModel;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.AbstractLogEntryViewerPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class LogEntryDatabaseViewerPanel
extends AbstractLogEntryViewerPanel
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener,
CleanUpHandler {
    private static final long serialVersionUID = -5878423449289564310L;
    public static final String FILENAME = "LogEntryDatabaseViewer.props";
    protected static Properties m_Properties;
    protected JButton m_ButtonOptions;
    protected JButton m_ButtonRefresh;
    protected JButton m_ButtonDelete;
    protected LogEntryConditions m_Conditions;
    protected GenericObjectEditorDialog m_OptionsDialog;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected void initialize() {
        super.initialize();
        Properties props = LogEntryDatabaseViewerPanel.getProperties();
        this.m_Conditions = (LogEntryConditions)LogEntryConditions.forCommandLine(props.getProperty("LogEntryConditions"));
        if (this.m_Conditions == null) {
            this.m_Conditions = new LogEntryConditions();
        }
        this.m_DatabaseConnection = DatabaseConnection.getSingleton();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = LogEntryDatabaseViewerPanel.getProperties();
        this.m_ButtonOptions = new JButton("Options");
        this.m_ButtonOptions.setMnemonic('O');
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogEntryDatabaseViewerPanel.this.showOptions();
            }
        });
        this.m_ButtonRefresh = new JButton("Refresh");
        this.m_ButtonRefresh.setMnemonic('R');
        this.m_ButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogEntryDatabaseViewerPanel.this.refresh();
            }
        });
        this.m_ButtonDelete = new JButton("Delete");
        this.m_ButtonDelete.setMnemonic('D');
        this.m_ButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogEntryDatabaseViewerPanel.this.delete();
            }
        });
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonOptions);
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonRefresh);
        this.m_TableEntries.addToButtonsPanel(new JLabel(""));
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonDelete);
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 250));
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        DatabaseConnection.getSingleton().addChangeListener(this);
        this.update();
    }

    @Override
    protected TextDialog createDetailsDialog() {
        TextDialog result = super.createDetailsDialog();
        Properties props = LogEntryDatabaseViewerPanel.getProperties();
        result.setSize(props.getInteger("DetailsDialog.Width", 400), props.getInteger("DetailsDialog.Height", 300));
        return result;
    }

    protected void showOptions() {
        if (this.m_OptionsDialog == null) {
            this.m_OptionsDialog = this.getParentDialog() != null ? GenericObjectEditorDialog.createDialog(this.getParentDialog()) : GenericObjectEditorDialog.createDialog(this.getParentFrame());
            this.m_OptionsDialog.getGOEEditor().setCanChangeClassInDialog(false);
            this.m_OptionsDialog.getGOEEditor().setClassType(AbstractConditions.class);
        }
        this.m_OptionsDialog.setCurrent(this.m_Conditions);
        this.m_OptionsDialog.setLocationRelativeTo(this);
        this.m_OptionsDialog.setVisible(true);
        if (this.m_OptionsDialog.getResult() != 0) {
            return;
        }
        this.m_Conditions = (LogEntryConditions)this.m_OptionsDialog.getCurrent();
    }

    protected void refresh() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LogEntryDatabaseViewerPanel.this.setEnabled(false);
                List<LogEntry> entries = LogT.getSingleton(LogEntryDatabaseViewerPanel.this.getDatabaseConnection()).load(LogEntryDatabaseViewerPanel.this.m_Conditions);
                LogEntryDatabaseViewerPanel.this.m_TableModelEntries.clear();
                LogEntryDatabaseViewerPanel.this.m_TableModelEntries.addAll(entries);
                LogEntryDatabaseViewerPanel.this.m_TableEntries.setOptimalColumnWidth();
                LogEntryDatabaseViewerPanel.this.m_TableMessage.setModel(new PropertiesTableModel());
                LogEntryDatabaseViewerPanel.this.setEnabled(true);
                LogEntryDatabaseViewerPanel.this.update();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void delete() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                int i;
                LogEntryDatabaseViewerPanel.this.setEnabled(false);
                int[] sel = LogEntryDatabaseViewerPanel.this.m_TableEntries.getSelectedRows();
                LogEntry[] entries = new LogEntry[sel.length];
                for (i = 0; i < sel.length; ++i) {
                    entries[i] = LogEntryDatabaseViewerPanel.this.m_TableModelEntries.getLogEntryAt(sel[i]);
                }
                for (i = 0; i < entries.length; ++i) {
                    LogT.getSingleton(LogEntryDatabaseViewerPanel.this.getDatabaseConnection()).remove(entries[i]);
                }
                return null;
            }

            @Override
            protected void done() {
                LogEntryDatabaseViewerPanel.this.setEnabled(true);
                super.done();
                LogEntryDatabaseViewerPanel.this.refresh();
            }
        };
        worker.execute();
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        boolean connected = DatabaseConnection.getSingleton().isConnected();
        this.m_ButtonOptions.setEnabled(connected);
        this.m_ButtonRefresh.setEnabled(connected);
        this.m_ButtonDelete.setEnabled(this.m_TableEntries.getSelectedRowCount() > 0 && connected);
    }

    @Override
    public void setEnabled(boolean value) {
        boolean connected = DatabaseConnection.getSingleton().isConnected();
        this.m_ButtonOptions.setEnabled(value && connected);
        this.m_ButtonRefresh.setEnabled(value && connected);
        this.m_ButtonDelete.setEnabled(value && connected);
        super.setEnabled(value);
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
        }
        this.updateButtons();
    }

    @Override
    public void cleanUp() {
        this.m_DatabaseConnection.removeChangeListener(this);
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection.removeChangeListener(this);
        this.m_DatabaseConnection = value;
        this.m_DatabaseConnection.addChangeListener(this);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("log entry db viewer panel");
        }
        return m_Properties;
    }
}

