/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.ArrayConsumer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionProducer;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OptionsConversionPanel
extends BasePanel {
    private static final long serialVersionUID = -2881786410361917678L;
    protected GenericObjectEditorPanel m_InputFormat;
    protected BaseTextAreaWithButtons m_TextAreaInput;
    protected JButton m_ButtonInputCopy;
    protected JButton m_ButtonInputPaste;
    protected JButton m_ButtonInputOpen;
    protected GenericObjectEditorPanel m_OutputFormat;
    protected BaseTextAreaWithButtons m_TextAreaOutput;
    protected JButton m_ButtonOutputCopy;
    protected JButton m_ButtonOutputPaste;
    protected JButton m_ButtonOutputSave;
    protected BaseTextAreaWithButtons m_TextAreaCodeOutput;
    protected JButton m_ButtonCodeOutputCopy;
    protected JButton m_ButtonCodeOutputPaste;
    protected JButton m_ButtonCodeOutputSave;
    protected JButton m_ButtonConvert;
    protected BaseFileChooser m_FileChooserInput;
    protected BaseFileChooser m_FileChooserOutput;
    protected BaseFileChooser m_FileChooserCodeOutput;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooserInput = new BaseFileChooser();
        this.m_FileChooserOutput = new BaseFileChooser();
        this.m_FileChooserCodeOutput = new BaseFileChooser();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelAll = new JPanel(new GridLayout(3, 1));
        this.add((Component)panelAll, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Input"));
        panelAll.add(panel);
        this.m_InputFormat = new GenericObjectEditorPanel(OptionConsumer.class, new ArrayConsumer(), true);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_InputFormat);
        this.m_TextAreaInput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaInput, "Center");
        this.m_ButtonInputCopy = new JButton("Copy", GUIHelper.getIcon("copy.gif"));
        this.m_ButtonInputCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaInput.getComponent()).copy();
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputCopy);
        this.m_ButtonInputPaste = new JButton("Paste", GUIHelper.getIcon("paste.gif"));
        this.m_ButtonInputPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaInput.getComponent()).paste();
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputPaste);
        this.m_ButtonInputOpen = new JButton("Open...", GUIHelper.getIcon("open.gif"));
        this.m_ButtonInputOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.openInput(OptionsConversionPanel.this.m_FileChooserInput, OptionsConversionPanel.this.m_TextAreaInput);
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputOpen);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Output"));
        panelAll.add(panel);
        this.m_OutputFormat = new GenericObjectEditorPanel(OptionProducer.class, new NestedProducer(), true);
        panel2 = new JPanel(new FlowLayout(0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_OutputFormat);
        this.m_TextAreaOutput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaOutput, "Center");
        this.m_ButtonOutputCopy = new JButton("Copy", GUIHelper.getIcon("copy.gif"));
        this.m_ButtonOutputCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaOutput.getComponent()).copy();
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputCopy);
        this.m_ButtonOutputPaste = new JButton("Paste", GUIHelper.getIcon("paste.gif"));
        this.m_ButtonOutputPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaOutput.getComponent()).paste();
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputPaste);
        this.m_ButtonOutputSave = new JButton("Save...", GUIHelper.getIcon("save.gif"));
        this.m_ButtonOutputSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.saveOutput(OptionsConversionPanel.this.m_FileChooserOutput, OptionsConversionPanel.this.m_TextAreaOutput);
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputSave);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Code output"));
        panelAll.add(panel);
        this.m_TextAreaCodeOutput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaCodeOutput, "Center");
        this.m_ButtonCodeOutputCopy = new JButton("Copy", GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCodeOutputCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaCodeOutput.getComponent()).copy();
            }
        });
        this.m_TextAreaCodeOutput.addToButtonsPanel(this.m_ButtonCodeOutputCopy);
        this.m_ButtonCodeOutputPaste = new JButton("Paste", GUIHelper.getIcon("paste.gif"));
        this.m_ButtonCodeOutputPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)OptionsConversionPanel.this.m_TextAreaCodeOutput.getComponent()).paste();
            }
        });
        this.m_TextAreaCodeOutput.addToButtonsPanel(this.m_ButtonCodeOutputPaste);
        this.m_ButtonCodeOutputSave = new JButton("Save...", GUIHelper.getIcon("save.gif"));
        this.m_ButtonCodeOutputSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.saveOutput(OptionsConversionPanel.this.m_FileChooserCodeOutput, OptionsConversionPanel.this.m_TextAreaCodeOutput);
            }
        });
        this.m_TextAreaCodeOutput.addToButtonsPanel(this.m_ButtonCodeOutputSave);
        panel = new JPanel(new FlowLayout(2));
        this.add((Component)panel, "South");
        this.m_ButtonConvert = new JButton("Convert");
        this.m_ButtonConvert.setMnemonic('C');
        this.m_ButtonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.convert();
            }
        });
        panel.add(this.m_ButtonConvert);
    }

    protected void openInput(BaseFileChooser filechooser, BaseTextAreaWithButtons textarea) {
        int retVal = filechooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        List<String> lines = FileUtils.loadFromFile(filechooser.getSelectedFile());
        textarea.setText(Utils.flatten(lines, "\n"));
    }

    protected void saveOutput(BaseFileChooser filechooser, BaseTextAreaWithButtons textarea) {
        int retVal = filechooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        String filename = filechooser.getSelectedFile().getAbsolutePath();
        if (!FileUtils.writeToFile(filename, (Object)textarea.getText(), false)) {
            GUIHelper.showErrorMessage(this, "Failed to write output to '" + filename + "'!");
        }
    }

    protected void convert() {
        try {
            OptionConsumer consumer = (OptionConsumer)this.m_InputFormat.getCurrent();
            OptionHandler handler = consumer.fromString(this.m_TextAreaInput.getText());
            if (handler == null) {
                throw new IllegalStateException("Failed to parse input!" + (consumer.hasErrors() ? "\n" + Utils.flatten(consumer.getErrors(), "\n") : ""));
            }
            OptionProducer producer = (OptionProducer)this.m_OutputFormat.getCurrent();
            producer.produce(handler);
            this.m_TextAreaOutput.setText(producer.toString());
            ((BaseTextArea)this.m_TextAreaOutput.getComponent()).setCaretPosition(0);
            this.m_TextAreaCodeOutput.setText("\"" + Utils.backQuoteChars(this.m_TextAreaOutput.getText()) + "\"");
            ((BaseTextArea)this.m_TextAreaCodeOutput.getComponent()).setCaretPosition(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GUIHelper.showErrorMessage(this, "Failed to convert options:\n" + ex);
        }
    }
}

