/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.MouseMovementTracker;
import adams.gui.visualization.core.plot.ContentPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CrossHairTracker
extends AbstractStrokePaintlet
implements MouseMovementTracker {
    private static final long serialVersionUID = -6562614432508466918L;
    protected Color m_Color;

    @Override
    public String globalInfo() {
        return "A cross-hair mouse movement tracker.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", Color.BLACK);
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the cross-hair.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        ContentPanel panel = this.getPlot().getContent();
        Point point = panel.getMousePosition();
        if (point == null) {
            return;
        }
        int x = (int)point.getX();
        int y = (int)point.getY();
        g.setColor(this.m_Color);
        g.drawLine(0, y, panel.getWidth(), y);
        g.drawLine(x, 0, x, panel.getHeight());
    }

    @Override
    public void mouseMovementTracked(MouseEvent e) {
        this.getPanel().getPlot().getContent().repaint();
    }

    @Override
    public MouseMovementTracker shallowCopyTracker() {
        return (MouseMovementTracker)((Object)this.shallowCopy());
    }

    @Override
    public MouseMovementTracker shallowCopyTracker(boolean expand) {
        return (MouseMovementTracker)((Object)this.shallowCopy(expand));
    }
}

