/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.gui.event.ImagePanelSelectionEvent;
import adams.gui.event.ImagePanelSelectionListener;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Point;

public abstract class AbstractSelectionProcessor
extends AbstractOptionHandler
implements ImagePanelSelectionListener,
ShallowCopySupporter<AbstractSelectionProcessor> {
    private static final long serialVersionUID = 3515366296579391750L;

    protected void doImageChanged(ImagePanel.PaintPanel panel) {
        this.reset();
    }

    @Override
    public void imageChanged(ImagePanel.PaintPanel panel) {
        this.doImageChanged(panel);
    }

    protected abstract void doProcessSelection(ImagePanel var1, Point var2, Point var3, int var4);

    public void processSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        this.doProcessSelection(panel, topLeft, bottomRight, modifiersEx);
        panel.repaint();
    }

    protected String check(ImagePanelSelectionEvent e) {
        if (e.getImagePanel() == null) {
            return "No ImagePanel associated with event!";
        }
        if (e.getTopLeft() == null) {
            return "No top-left position associated with event!";
        }
        if (e.getBottomRight() == null) {
            return "No bottom-right position associated with event!";
        }
        return null;
    }

    @Override
    public void selected(ImagePanelSelectionEvent e) {
        String msg = this.check(e);
        if (msg == null) {
            this.processSelection(e.getImagePanel(), e.getTopLeft(), e.getBottomRight(), e.getModifiersEx());
        } else {
            this.getLogger().severe(msg);
        }
    }

    @Override
    public AbstractSelectionProcessor shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractSelectionProcessor shallowCopy(boolean expand) {
        return (AbstractSelectionProcessor)OptionUtils.shallowCopy(this, expand);
    }
}

