/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.BarHitDetector;
import adams.gui.visualization.sequence.PaintletWithCustomDataSupport;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class BarPaintlet
extends AbstractXYSequencePaintlet
implements PaintletWithCustomDataSupport {
    private static final long serialVersionUID = 8968797530613834056L;
    protected boolean m_PaintAll;
    protected int m_Width;
    protected int m_Offset;
    protected int m_CurrentOffset;

    @Override
    public String globalInfo() {
        return "Paintlet for painting a bar plot for a sequence.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", 20, 1, null);
        this.m_OptionManager.add("offset", "offset", 0);
        this.m_OptionManager.add("paint-all", "paintAll", false);
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.memberChanged();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the bar in pixel.";
    }

    public void setOffset(int value) {
        this.m_Offset = value;
        this.memberChanged();
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The X offset for additional sequences in pixel.";
    }

    public void setPaintAll(boolean value) {
        this.m_PaintAll = value;
        this.memberChanged();
    }

    public boolean getPaintAll() {
        return this.m_PaintAll;
    }

    public String paintAllTipText() {
        return "If set to true, all data points will be painted, regardless whether they are visible or not.";
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        BarHitDetector result = new BarHitDetector(this);
        result.setWidth(this.m_Width);
        return result;
    }

    @Override
    protected void updateHitDetector() {
        ((BarHitDetector)this.m_HitDetector).setWidth(this.m_Width);
    }

    @Override
    public void drawCustomData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        int end;
        int start;
        List<XYSequencePoint> points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        if (this.m_PaintAll) {
            start = 0;
            end = data.size() - 1;
        } else {
            start = XYSequenceUtils.findClosestX(points, Math.floor(axisX.getMinimum()));
            if (start > 0) {
                --start;
            }
            if ((end = XYSequenceUtils.findClosestX(points, Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
                ++end;
            }
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevX = axisX.valueToPos(points.get(start).getX());
        for (int i = start; i <= end; ++i) {
            XYSequencePoint curr = points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            if (!this.m_PaintAll && i != start && i != end && (currX += this.m_CurrentOffset) + this.m_Width < prevX) continue;
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            g.fillRect(currX - this.m_Width / 2, Math.min(axisY.valueToPos(0.0), currY), this.m_Width, Math.abs(axisY.valueToPos(0.0) - currY));
            prevX = currX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            this.m_CurrentOffset = 0;
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawCustomData(g, moment, data, this.getColor(i));
                }
                this.m_CurrentOffset += this.m_Offset;
            }
            this.m_CurrentOffset = 0;
        }
    }
}

