/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CircleHitDetector;
import adams.gui.visualization.sequence.PaintletWithCustomDataSupport;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class CirclePaintlet
extends AbstractXYSequencePaintlet
implements AntiAliasingSupporter,
PaintletWithCustomDataSupport {
    private static final long serialVersionUID = -8772546156227148237L;
    protected int m_Diameter;
    protected boolean m_AntiAliasingEnabled;

    @Override
    public String globalInfo() {
        return "Paintlet for simply painting circles at the specified X-Y position.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("diameter", "diameter", 7, 1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", GUIHelper.getBoolean(this.getClass(), "antiAliasingEnabled", true));
    }

    public void setDiameter(int value) {
        this.m_Diameter = value;
        this.memberChanged();
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle in pixels.";
    }

    @Override
    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    @Override
    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing circles.";
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new CircleHitDetector(this);
    }

    @Override
    public void drawCustomData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        GUIHelper.configureAntiAliasing(g, this.m_AntiAliasingEnabled);
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        for (int i = 0; i < data.size(); ++i) {
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            g.drawOval(currX -= this.m_Diameter / 2, currY -= this.m_Diameter / 2, this.m_Diameter - 1, this.m_Diameter - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawCustomData(g, moment, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

