/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.meta.SubsetLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.ConditionalDependenceIdentifier;
import mulan.data.LabelPairsDependenceIdentifier;
import mulan.data.LabelsPair;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.TechnicalInformation;

public class EnsembleOfSubsetLearners
extends MultiLabelMetaLearner {
    SubsetLearner[] ensembleModels;
    int numModels = 10;
    double threshold = 0.5;
    LabelPairsDependenceIdentifier dependenceIdentifier;
    Classifier singleLabelLearner;
    boolean selectDiverseModels = true;
    boolean useSubsetcache = false;
    private int seed = 1;
    private Random rnd;
    private static int numOfRandomPartitions = 50000;
    private static int numOfPartitionsForDiversity = 100;
    private static double dynamicDiversityThreshold = 0.2;

    public EnsembleOfSubsetLearners() {
        this(new BinaryRelevance((Classifier)new J48()), (Classifier)new J48(), new ConditionalDependenceIdentifier((Classifier)new J48()), 10);
    }

    public EnsembleOfSubsetLearners(MultiLabelLearner aMultiLabelLearner, Classifier aSingleLabelLearner, LabelPairsDependenceIdentifier aDependenceIdentifier, int models) {
        super(aMultiLabelLearner);
        this.singleLabelLearner = aSingleLabelLearner;
        this.dependenceIdentifier = aDependenceIdentifier;
        this.numModels = models;
        this.rnd = new Random(this.seed);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lena Tenenboim-Chekina, Lior Rokach, and Bracha Shapira");
        result.setValue(TechnicalInformation.Field.TITLE, "Identification of Label Dependencies for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.VOLUME, "Proc. ICML 2010 Workshop on Learning from Multi-Label Data (MLD'10");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.PAGES, "53--60");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Haifa, Israel");
        return result;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingData) throws Exception {
        int totalSubsets = 0;
        List<LabelSubsetsWeight> pairsList = this.createLabelSetPartitions(trainingData);
        this.ensembleModels = new SubsetLearner[this.numModels];
        for (int m = 0; m < this.numModels; ++m) {
            LabelSubsetsWeight pair = pairsList.get(m);
            int[][] comb = pair.getSubsets();
            this.ensembleModels[m] = new SubsetLearner(comb, this.singleLabelLearner);
            this.ensembleModels[m].setUseCache(this.useSubsetcache);
            totalSubsets += comb.length;
            this.debug("Building model" + m + ":" + EnsembleOfSubsetLearners.partitionToString(comb) + " weight=" + pair.getValue());
            this.ensembleModels[m].build(trainingData);
        }
        this.debug("Total Subsets  =" + totalSubsets + '\n');
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        int[] sumVotes = new int[this.numLabels];
        for (int i = 0; i < this.numModels; ++i) {
            MultiLabelOutput ensembleMLO = this.ensembleModels[i].makePrediction(instance);
            boolean[] bip = ensembleMLO.getBipartition();
            for (int j = 0; j < sumVotes.length; ++j) {
                int n = j;
                sumVotes[n] = sumVotes[n] + (bip[j] ? 1 : 0);
            }
        }
        double[] confidence = new double[this.numLabels];
        for (int j = 0; j < sumVotes.length; ++j) {
            confidence[j] = (double)sumVotes[j] / (double)this.numModels;
        }
        return new MultiLabelOutput(confidence, this.threshold);
    }

    public List<int[][]> createRandomSets(int numLabels, int numSets) {
        int n = 2 * numLabels - 1;
        int[][] permutations = this.GenerateRandomPermutations(n, numSets);
        List<int[][]> sets = EnsembleOfSubsetLearners.convertToSets(permutations, numLabels);
        return sets;
    }

    public static String partitionToString(int[][] partition) {
        StringBuilder result = new StringBuilder();
        for (int[] aGroup : partition) {
            result.append(Arrays.toString(aGroup));
            result.append(", ");
        }
        return result.toString();
    }

    private List<LabelSubsetsWeight> createLabelSetPartitions(MultiLabelInstances trainingData) {
        List<LabelSubsetsWeight> selectedSets;
        LabelsPair[] labelPairs = this.dependenceIdentifier.calculateDependence(trainingData);
        double criticalValue = this.dependenceIdentifier.getCriticalValue();
        double[][] weightsMatrix = EnsembleOfSubsetLearners.createDependenceWeightsMatrix(labelPairs, criticalValue, this.numLabels, true);
        List<int[][]> randomPartitions = this.createRandomSets(this.numLabels, numOfRandomPartitions);
        ArrayList<LabelSubsetsWeight> weightedSets = this.setWeights(randomPartitions, weightsMatrix);
        Collections.sort(weightedSets, Collections.reverseOrder());
        List<LabelSubsetsWeight> distinctSets = EnsembleOfSubsetLearners.getDistinctSets(weightedSets);
        if (this.selectDiverseModels) {
            int numForDiversity = Math.min(distinctSets.size(), numOfPartitionsForDiversity);
            List<LabelSubsetsWeight> highestSets = EnsembleOfSubsetLearners.getHighOrdered(distinctSets, numForDiversity);
            selectedSets = this.selectByDiversity(highestSets);
        } else {
            selectedSets = EnsembleOfSubsetLearners.getHighOrdered(distinctSets, this.numModels);
        }
        return selectedSets;
    }

    private static double[][] createDependenceWeightsMatrix(LabelsPair[] pairsList, double critical, int n, boolean normalized) {
        double[][] matrix = new double[n][n];
        for (LabelsPair pair : pairsList) {
            Double value = pair.getScore();
            int[] data = pair.getPair();
            if (normalized) {
                if (data[0] < data[1]) {
                    matrix[data[0]][data[1]] = value - critical;
                    continue;
                }
                matrix[data[1]][data[0]] = value - critical;
                continue;
            }
            if (data[0] < data[1]) {
                matrix[data[0]][data[1]] = value;
                continue;
            }
            matrix[data[1]][data[0]] = value;
        }
        return matrix;
    }

    private int[][] GenerateRandomPermutations(int n, int num) {
        int[][] permutations = new int[num][];
        int[] a = EnsembleOfSubsetLearners.initialize(n);
        for (int i = 0; i < num; ++i) {
            int[] rand = this.randomize(a);
            permutations[i] = rand;
        }
        return permutations;
    }

    private static int[] initialize(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = i;
        }
        return a;
    }

    private int[] randomize(int[] a) {
        int[] b = (int[])a.clone();
        for (int k = b.length - 1; k > 0; --k) {
            int w = (int)Math.floor(this.rnd.nextDouble() * (double)(k + 1));
            int temp = b[w];
            b[w] = b[k];
            b[k] = temp;
        }
        return b;
    }

    private static List<int[][]> convertToSets(int[][] permutations, int numLabels) {
        ArrayList<int[][]> sets = new ArrayList<int[][]>();
        for (int[] permutation : permutations) {
            List<Integer[]> groupsList = EnsembleOfSubsetLearners.extractGroups(permutation, numLabels);
            sets.add(EnsembleOfSubsetLearners.createSet(groupsList));
        }
        return sets;
    }

    private static List<Integer[]> extractGroups(int[] permutation, int numLabels) {
        ArrayList<Integer[]> groupsList = new ArrayList<Integer[]>();
        ArrayList<Integer> group = new ArrayList<Integer>();
        for (int value : permutation) {
            if (value < numLabels) {
                group.add(value);
                continue;
            }
            if (group.size() <= 0) continue;
            Integer[] gr = group.toArray(new Integer[group.size()]);
            groupsList.add(gr);
            group = new ArrayList();
        }
        if (group.size() > 0) {
            Integer[] gr = group.toArray(new Integer[group.size()]);
            groupsList.add(gr);
        }
        return groupsList;
    }

    private static int[][] createSet(List<Integer[]> groupsList) {
        int numGroups = groupsList.size();
        int[][] sets = new int[numGroups][];
        Integer[][] sets2 = (Integer[][])groupsList.toArray((T[])new Integer[groupsList.size()][]);
        for (int i = 0; i < sets2.length; ++i) {
            sets[i] = new int[sets2[i].length];
            for (int j = 0; j < sets2[i].length; ++j) {
                sets[i][j] = sets2[i][j];
            }
        }
        return sets;
    }

    private ArrayList<LabelSubsetsWeight> setWeights(List<int[][]> partitions, double[][] weightsMatrix) {
        ArrayList<LabelSubsetsWeight> weightedList = new ArrayList<LabelSubsetsWeight>(partitions.size());
        for (int[][] partition : partitions) {
            Double weight = EnsembleOfSubsetLearners.computeWeight(partition, weightsMatrix, this.numLabels);
            LabelSubsetsWeight p = new LabelSubsetsWeight(weight, partition);
            weightedList.add(p);
        }
        return weightedList;
    }

    private static Double computeWeight(int[][] partition, double[][] weightsMatrix, int numLabels) {
        double[][] matrix = EnsembleOfSubsetLearners.deepClone(weightsMatrix);
        Double weight = 0.0;
        TreeSet<Integer> ind = new TreeSet<Integer>();
        TreeSet<Integer> dep = new TreeSet<Integer>();
        int[][] arr$ = partition;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] aGroup;
            for (int aLabel : aGroup = arr$[i$]) {
                for (int bLabel : aGroup) {
                    dep.add(bLabel);
                }
                for (int n = 0; n < numLabels; ++n) {
                    if (dep.contains(n)) continue;
                    ind.add(n);
                }
                weight = weight + EnsembleOfSubsetLearners.weightOf(dep, aLabel, matrix);
                weight = weight - EnsembleOfSubsetLearners.weightOf(ind, aLabel, matrix);
            }
        }
        return weight;
    }

    private static double[][] deepClone(double[][] matrix) {
        double[][] m = new double[matrix.length][];
        for (int i = 0; i < matrix.length; ++i) {
            m[i] = (double[])matrix[i].clone();
        }
        return m;
    }

    private static Double weightOf(TreeSet<Integer> otherLabels, int label, double[][] matrix) {
        Double w = 0.0;
        for (Integer l2 : otherLabels) {
            if (label < l2) {
                w = w + matrix[label][l2];
                matrix[label][l2.intValue()] = 0.0;
                continue;
            }
            w = w + matrix[l2][label];
            matrix[l2.intValue()][label] = 0.0;
        }
        return w;
    }

    private static List<LabelSubsetsWeight> getDistinctSets(List<LabelSubsetsWeight> orderedList) {
        ArrayList<LabelSubsetsWeight> distinct = new ArrayList<LabelSubsetsWeight>();
        long v = 0L;
        for (LabelSubsetsWeight subset : orderedList) {
            long value = subset.getValue().longValue();
            if (v != value) {
                distinct.add(subset);
            }
            v = value;
        }
        return distinct;
    }

    private static List<LabelSubsetsWeight> getHighOrdered(List<LabelSubsetsWeight> orderedList, int number) {
        ArrayList<LabelSubsetsWeight> highest = new ArrayList<LabelSubsetsWeight>();
        int count = 0;
        for (LabelSubsetsWeight subset : orderedList) {
            highest.add(subset);
            if (++count != number) continue;
            return highest;
        }
        return highest;
    }

    private static int distance(LabelSubsetsWeight set1, LabelSubsetsWeight set2, int numLabels) {
        int dist = 0;
        int[][] set1Matrix = EnsembleOfSubsetLearners.matrixRepresentation(set1.getSubsets(), numLabels);
        int[][] set2Matrix = EnsembleOfSubsetLearners.matrixRepresentation(set2.getSubsets(), numLabels);
        for (int i = 0; i < numLabels; ++i) {
            for (int j = i + 1; j < numLabels; ++j) {
                if ((set1Matrix[i][j] != 0 || set2Matrix[i][j] != 1) && (set1Matrix[i][j] != 1 || set2Matrix[i][j] != 0)) continue;
                ++dist;
            }
        }
        return dist;
    }

    private static int[][] matrixRepresentation(int[][] set, int numLabels) {
        int[][] setMatrix;
        for (int[] anArray : setMatrix = new int[numLabels][numLabels]) {
            Arrays.fill(anArray, 0);
        }
        for (int[] aGroup : set) {
            for (int j = 0; j < aGroup.length; ++j) {
                int l1 = aGroup[j];
                for (int k = j + 1; k < aGroup.length; ++k) {
                    int l2 = aGroup[k];
                    setMatrix[l1][l2] = 1;
                    setMatrix[l2][l1] = 1;
                }
            }
        }
        return setMatrix;
    }

    private List<LabelSubsetsWeight> selectByDiversity(List<LabelSubsetsWeight> sets) {
        ArrayList<LabelSubsetsWeight> selected = new ArrayList<LabelSubsetsWeight>();
        selected.add(sets.get(0));
        for (int i = 1; i < this.numModels; ++i) {
            Object[] minDistToSelected = this.minDistToSelected(sets, selected);
            Arrays.sort(minDistToSelected);
            int endIndx = minDistToSelected.length - 1;
            int startIndx = endIndx - (int)((double)minDistToSelected.length * dynamicDiversityThreshold);
            SubsetsDistance[] differentSets = (SubsetsDistance[])Arrays.copyOfRange(minDistToSelected, startIndx, endIndx);
            Arrays.sort(differentSets, new IdComparator());
            Integer setId = differentSets[0].getSubsetsId();
            LabelSubsetsWeight selectedSet = sets.get(setId);
            selected.add(selectedSet);
        }
        return selected;
    }

    private SubsetsDistance[] minDistToSelected(List<LabelSubsetsWeight> allSets, List<LabelSubsetsWeight> selected) {
        SubsetsDistance[] minDists = new SubsetsDistance[allSets.size()];
        int[] dists = new int[selected.size()];
        int i = 0;
        for (LabelSubsetsWeight set1 : allSets) {
            int j = 0;
            for (LabelSubsetsWeight set2 : selected) {
                int d = EnsembleOfSubsetLearners.distance(set1, set2, this.numLabels);
                dists[j++] = d;
            }
            Arrays.sort(dists);
            int min = dists[0];
            SubsetsDistance p = new SubsetsDistance(i, min);
            minDists[i++] = p;
        }
        return minDists;
    }

    public void setRnd(Random rnd) {
        this.rnd = rnd;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setDependenceIdentifier(LabelPairsDependenceIdentifier dependenceIdentifier) {
        this.dependenceIdentifier = dependenceIdentifier;
    }

    public void setSeed(int x) {
        this.seed = x;
        this.rnd = new Random(this.seed);
    }

    public void setNumModels(int models) {
        this.numModels = models;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public boolean isSelectDiverseModels() {
        return this.selectDiverseModels;
    }

    public void setSelectDiverseModels(boolean selectDiverseModels) {
        this.selectDiverseModels = selectDiverseModels;
    }

    public void setUseSubsetLearnerCache(boolean useSubsetcache) {
        this.useSubsetcache = useSubsetcache;
    }

    public static void setNumOfRandomPartitions(int numOfRandomPartitions) {
        EnsembleOfSubsetLearners.numOfRandomPartitions = numOfRandomPartitions;
    }

    public static void setNumOfPartitionsForDiversity(int numOfPartitionsForDiversity) {
        EnsembleOfSubsetLearners.numOfPartitionsForDiversity = numOfPartitionsForDiversity;
    }

    public static void setDynamicDiversityThreshold(double dynamicDiversityThreshold) {
        EnsembleOfSubsetLearners.dynamicDiversityThreshold = dynamicDiversityThreshold;
    }

    @Override
    public String globalInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("A class for gathering several different SubsetLearners ");
        sb.append("into a composite ensemble model. <br> <br> The label set ");
        sb.append("partitions for participation in ensemble are selected ");
        sb.append("using their dependence weight from the large number of ");
        sb.append("randomly generated possible partitions. The type of the ");
        sb.append("learned dependencies is determined by the ");
        sb.append("{@link mulan.data.LabelPairsDependenceIdentifier} supplied");
        sb.append(" to the class constructor. Two strategies for selecting ");
        sb.append("ensemble partitions exists: (1) to select the highly ");
        sb.append("weighted ones and (2) to select most different from the ");
        sb.append("highly weighted ones. The strategy to be used is ");
        sb.append("determined by the {@link #selectDiverseModels} parameter ");
        sb.append("which is 'true' by default.\n\nFor more information, ");
        sb.append("see\n\n").append(this.getTechnicalInformation().toString());
        return sb.toString();
    }

    private class IdComparator
    implements Comparator {
        private IdComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof SubsetsDistance && o2 instanceof SubsetsDistance) {
                SubsetsDistance s1 = (SubsetsDistance)o1;
                SubsetsDistance s2 = (SubsetsDistance)o2;
                Integer i1 = s1.getSubsetsId();
                Integer i2 = s2.getSubsetsId();
                return i1.compareTo(i2);
            }
            return 0;
        }
    }

    private class SubsetsDistance
    implements Comparable {
        Integer subsetsId;
        Integer value;

        public SubsetsDistance(int _id, int v) {
            this.subsetsId = _id;
            this.value = v;
        }

        public Integer getSubsetsId() {
            return this.subsetsId;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubsetsDistance pair = (SubsetsDistance)o;
            return !(this.value == null ? pair.value != null : !this.value.equals(pair.value));
        }

        public int compareTo(Object otherPair) {
            if (otherPair == null) {
                throw new NullPointerException();
            }
            if (!(otherPair instanceof SubsetsDistance)) {
                throw new ClassCastException("Invalid object");
            }
            Integer value = ((SubsetsDistance)otherPair).getValue();
            if (this.getValue() > value) {
                return 1;
            }
            if (this.getValue() < value) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    private class LabelSubsetsWeight
    implements Comparable,
    Cloneable {
        int[][] subsets;
        Double value;

        public LabelSubsetsWeight(double v, int[][] comb) {
            this.subsets = comb;
            this.value = v;
        }

        public int[][] getSubsets() {
            return this.subsets;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelSubsetsWeight pair = (LabelSubsetsWeight)o;
            return !(this.value == null ? pair.value != null : !this.value.equals(pair.value));
        }

        public int compareTo(Object otherPair) {
            if (otherPair == null) {
                throw new NullPointerException();
            }
            if (!(otherPair instanceof LabelSubsetsWeight)) {
                throw new ClassCastException("Invalid object");
            }
            Double value = ((LabelSubsetsWeight)otherPair).getValue();
            if (this.getValue() > value) {
                return 1;
            }
            if (this.getValue() < value) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

