/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.LabelSet;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public abstract class LabelsetPruning
extends LabelPowerset {
    HashMap<LabelSet, ArrayList<Instance>> ListInstancePerLabel;
    protected int p;
    Instances format;

    public LabelsetPruning(Classifier classifier, int aP) {
        super(classifier);
        if (aP <= 0) {
            throw new IllegalArgumentException("p should be larger than 0!");
        }
        this.p = aP;
        this.setConfidenceCalculationMethod(2);
        this.setMakePredictionsBasedOnConfidences(true);
        this.threshold = 0.21;
    }

    abstract ArrayList<Instance> processRejected(LabelSet var1);

    @Override
    protected void buildInternal(MultiLabelInstances mlDataSet) throws Exception {
        Instances data = mlDataSet.getDataSet();
        this.format = new Instances(data, 0);
        int numInstances = data.numInstances();
        this.ListInstancePerLabel = new HashMap();
        for (int i = 0; i < numInstances; ++i) {
            double[] dblLabels = new double[this.numLabels];
            for (int j = 0; j < this.numLabels; ++j) {
                double value;
                int index = this.labelIndices[j];
                dblLabels[j] = value = Double.parseDouble(data.attribute(index).value((int)data.instance(i).value(index)));
            }
            LabelSet labelSet = new LabelSet(dblLabels);
            if (this.ListInstancePerLabel.containsKey(labelSet)) {
                this.ListInstancePerLabel.get(labelSet).add(data.instance(i));
                continue;
            }
            ArrayList<Instance> li = new ArrayList<Instance>();
            li.add(data.instance(i));
            this.ListInstancePerLabel.put(labelSet, li);
        }
        Instances newData = new Instances(data, 0);
        for (LabelSet ls : this.ListInstancePerLabel.keySet()) {
            ArrayList<Instance> instances = this.ListInstancePerLabel.get(ls);
            if (instances.size() > this.p) {
                for (int i = 0; i < instances.size(); ++i) {
                    newData.add(instances.get(i));
                }
                continue;
            }
            ArrayList<Instance> processed = this.processRejected(ls);
            newData.addAll(processed);
        }
        super.buildInternal(new MultiLabelInstances(newData, mlDataSet.getLabelsMetaData()));
    }
}

