/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluation;
import mulan.evaluation.measure.MacroAverageMeasure;
import mulan.evaluation.measure.Measure;

public class MultipleEvaluation {
    private MultiLabelInstances data;
    private ArrayList<Evaluation> evaluations = new ArrayList();
    private HashMap<String, Double> mean;
    private HashMap<String, Double> standardDeviation;
    private HashMap<String, Double[]> labelMean;
    private HashMap<String, Double[]> labelStandardDeviation;

    public MultipleEvaluation(MultiLabelInstances data) {
        this.data = data;
    }

    public MultipleEvaluation(Evaluation[] someEvaluations, MultiLabelInstances data) {
        this.evaluations.addAll(Arrays.asList(someEvaluations));
        this.data = data;
    }

    public void calculateStatistics() {
        int size = this.evaluations.size();
        HashMap<String, Double> sums = new HashMap<String, Double>();
        HashMap<String, Double[]> labelSums = new HashMap<String, Double[]>();
        for (int i = 0; i < this.evaluations.size(); ++i) {
            for (Measure m : this.evaluations.get(i).getMeasures()) {
                double value = Double.NaN;
                try {
                    value = m.getValue();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (sums.containsKey(m.getName())) {
                    sums.put(m.getName(), (Double)sums.get(m.getName()) + value);
                } else {
                    sums.put(m.getName(), value);
                }
                if (!(m instanceof MacroAverageMeasure)) continue;
                Double[] v = new Double[this.data.getNumLabels()];
                for (int j = 0; j < this.data.getNumLabels(); ++j) {
                    v[j] = ((MacroAverageMeasure)((Object)m)).getValue(j);
                }
                if (labelSums.containsKey(m.getName())) {
                    Double[] v_old = (Double[])labelSums.get(m.getName());
                    for (int j = 0; j < this.data.getNumLabels(); ++j) {
                        Double[] doubleArray = v;
                        int n = j;
                        Double.valueOf(doubleArray[n] + v_old[j]);
                    }
                }
                labelSums.put(m.getName(), v);
            }
        }
        this.mean = new HashMap();
        for (String measureName : sums.keySet()) {
            this.mean.put(measureName, (Double)sums.get(measureName) / (double)size);
        }
        this.labelMean = new HashMap();
        for (String measureName : labelSums.keySet()) {
            Double[] v = (Double[])labelSums.get(measureName);
            for (int j = 0; j < this.data.getNumLabels(); ++j) {
                v[j] = v[j] / (double)size;
            }
            this.labelMean.put(measureName, v);
        }
        sums = new HashMap();
        labelSums = new HashMap();
        for (int i = 0; i < this.evaluations.size(); ++i) {
            for (Measure m : this.evaluations.get(i).getMeasures()) {
                double value = Double.NaN;
                try {
                    value = m.getValue();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (sums.containsKey(m.getName())) {
                    sums.put(m.getName(), (Double)sums.get(m.getName()) + Math.pow(value - this.mean.get(m.getName()), 2.0));
                } else {
                    sums.put(m.getName(), Math.pow(value - this.mean.get(m.getName()), 2.0));
                }
                if (!(m instanceof MacroAverageMeasure)) continue;
                Double[] mean = this.labelMean.get(m.getName());
                Double[] v = new Double[this.data.getNumLabels()];
                for (int j = 0; j < this.data.getNumLabels(); ++j) {
                    v[j] = ((MacroAverageMeasure)((Object)m)).getValue(j);
                }
                if (labelSums.containsKey(m.getName())) {
                    Double[] v_old = (Double[])labelSums.get(m.getName());
                    for (int j = 0; j < this.data.getNumLabels(); ++j) {
                        v[j] = Math.pow(v[j] - mean[j], 2.0) + v_old[j];
                    }
                }
                labelSums.put(m.getName(), v);
            }
        }
        this.standardDeviation = new HashMap();
        for (String measureName : sums.keySet()) {
            this.standardDeviation.put(measureName, Math.sqrt((Double)sums.get(measureName) / (double)size));
        }
        this.labelStandardDeviation = new HashMap();
        for (String measureName : labelSums.keySet()) {
            Double[] s = (Double[])labelSums.get(measureName);
            int j = 0;
            while (j < this.data.getNumLabels()) {
                Double[] doubleArray = s;
                int n = j++;
                Double.valueOf(doubleArray[n] / (double)size);
            }
            this.labelStandardDeviation.put(measureName, s);
        }
    }

    public void addEvaluation(Evaluation evaluation) {
        this.evaluations.add(evaluation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Measure m : this.evaluations.get(0).getMeasures()) {
            String measureName = m.getName();
            sb.append(measureName);
            sb.append(": ");
            sb.append(String.format("%.4f", this.mean.get(measureName)));
            sb.append("\u00b1");
            sb.append(String.format("%.4f", this.standardDeviation.get(measureName)));
            sb.append("\n");
            if (!(m instanceof MacroAverageMeasure)) continue;
            Double[] v = this.labelMean.get(measureName);
            Double[] s = this.labelStandardDeviation.get(measureName);
            for (int i = 0; i < this.data.getNumLabels(); ++i) {
                sb.append(this.data.getDataSet().attribute(this.data.getLabelIndices()[i]).name()).append(": ");
                sb.append(String.format("%.4f", v[i]));
                sb.append("\u00b1");
                sb.append(String.format("%.4f", s[i]));
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public double getMean(String measureName) {
        return this.mean.get(measureName);
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        for (Measure m : this.evaluations.get(0).getMeasures()) {
            String measureName = m.getName();
            sb.append(String.format("%.4f", this.mean.get(measureName)));
            sb.append("\u00b1");
            sb.append(String.format("%.4f", this.standardDeviation.get(measureName)));
            sb.append(";");
        }
        return sb.toString();
    }
}

