/*
 * Decompiled with CFR 0.152.
 */
package mulan.experiments;

import java.util.ArrayList;
import mulan.classifier.lazy.MLkNN;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluator;
import mulan.evaluation.MultipleEvaluation;
import mulan.evaluation.measure.AveragePrecision;
import mulan.evaluation.measure.Coverage;
import mulan.evaluation.measure.HammingLoss;
import mulan.evaluation.measure.Measure;
import mulan.evaluation.measure.OneError;
import mulan.evaluation.measure.RankingLoss;
import mulan.experiments.Experiment;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class PatternRecognition07MLkNN
extends Experiment {
    public static void main(String[] args) {
        try {
            String path = Utils.getOption((String)"path", (String[])args);
            String filestem = Utils.getOption((String)"filestem", (String[])args);
            System.out.println("Loading the data set");
            MultiLabelInstances dataSet = new MultiLabelInstances(path + filestem + ".arff", path + filestem + ".xml");
            Evaluator eval = new Evaluator();
            ArrayList<Measure> measures = new ArrayList<Measure>(5);
            measures.add(new HammingLoss());
            measures.add(new OneError());
            measures.add(new Coverage());
            measures.add(new RankingLoss());
            measures.add(new AveragePrecision());
            int i = 8;
            while (i <= 12) {
                System.out.println("MLkNN Experiment for " + i + " neighbors:");
                int numOfNeighbors = i++;
                double smooth = 1.0;
                MLkNN mlknn = new MLkNN(numOfNeighbors, smooth);
                MultipleEvaluation results = eval.crossValidate(mlknn, dataSet, measures, 10);
                System.out.println(results);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Min-Ling Zhang and Zhi-Hua Zhou");
        result.setValue(TechnicalInformation.Field.TITLE, "ML-KNN: A lazy learning approach to multi-label learning");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recogn.");
        result.setValue(TechnicalInformation.Field.VOLUME, "40");
        result.setValue(TechnicalInformation.Field.NUMBER, "7");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.ISSN, "0031-3203");
        result.setValue(TechnicalInformation.Field.PAGES, "2038--2048");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Elsevier Science Inc.");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        return result;
    }
}

