/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.feature.shapes.SplitMergeLineFitLoop;
import boofcv.alg.fiducial.BaseDetectFiducialSquare;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.util.Arrays;

public class DetectFiducialSquareBinary<T extends ImageSingleBand>
extends BaseDetectFiducialSquare<T> {
    InputToBinary<ImageFloat32> threshold = FactoryThresholdBinary.globalOtsu((int)0, (int)256, (boolean)true, ImageFloat32.class);
    ImageUInt8 binary = new ImageUInt8(1, 1);
    int[] counts = new int[16];
    int[] classified = new int[16];
    int[] tmp = new int[16];
    ImageFloat32 grayNoBorder = new ImageFloat32();
    protected static final int r = 5;
    protected static final int w = 11;
    protected static final int N = 121;

    public DetectFiducialSquareBinary(InputToBinary<T> thresholder, SplitMergeLineFitLoop fitPolygon, double minContourFraction, Class<T> inputType) {
        super(thresholder, fitPolygon, 88, minContourFraction, inputType);
        int widthNoBorder = 44;
        this.binary.reshape(widthNoBorder, widthNoBorder);
    }

    @Override
    protected boolean processSquare(ImageFloat32 gray, BaseDetectFiducialSquare.Result result) {
        int off = (gray.width - this.binary.width) / 2;
        gray.subimage(off, off, gray.width - off, gray.width - off, (ImageSingleBand)this.grayNoBorder);
        this.findBitCounts(this.grayNoBorder);
        if (this.thresholdBinaryNumber()) {
            return false;
        }
        if (this.rotateUntilInLowerCorner(result)) {
            return false;
        }
        int val = 0;
        val |= this.classified[13] << 0;
        val |= this.classified[14] << 1;
        val |= this.classified[8] << 2;
        val |= this.classified[9] << 3;
        val |= this.classified[10] << 4;
        val |= this.classified[11] << 5;
        val |= this.classified[4] << 6;
        val |= this.classified[5] << 7;
        val |= this.classified[6] << 8;
        val |= this.classified[7] << 9;
        val |= this.classified[1] << 10;
        result.which = val |= this.classified[2] << 11;
        return true;
    }

    private boolean rotateUntilInLowerCorner(BaseDetectFiducialSquare.Result result) {
        if (this.classified[0] + this.classified[3] + this.classified[15] + this.classified[12] != 1) {
            return true;
        }
        result.rotation = 0;
        while (this.classified[12] != 1) {
            ++result.rotation;
            this.rotateClockWise();
        }
        return false;
    }

    protected void rotateClockWise() {
        this.tmp[0] = this.classified[12];
        this.tmp[1] = this.classified[8];
        this.tmp[2] = this.classified[4];
        this.tmp[3] = this.classified[0];
        this.tmp[4] = this.classified[13];
        this.tmp[5] = this.classified[9];
        this.tmp[6] = this.classified[5];
        this.tmp[7] = this.classified[1];
        this.tmp[8] = this.classified[14];
        this.tmp[9] = this.classified[10];
        this.tmp[10] = this.classified[6];
        this.tmp[11] = this.classified[2];
        this.tmp[12] = this.classified[15];
        this.tmp[13] = this.classified[11];
        this.tmp[14] = this.classified[7];
        this.tmp[15] = this.classified[3];
        System.arraycopy(this.tmp, 0, this.classified, 0, 16);
    }

    private boolean thresholdBinaryNumber() {
        int lower = 18;
        int upper = 102;
        for (int i = 0; i < 16; ++i) {
            if (this.counts[i] < lower) {
                this.classified[i] = 0;
                continue;
            }
            if (this.counts[i] > upper) {
                this.classified[i] = 1;
                continue;
            }
            return true;
        }
        return false;
    }

    private void findBitCounts(ImageFloat32 gray) {
        this.threshold.process((ImageBase)gray, (ImageBase)this.binary);
        Arrays.fill(this.counts, 0);
        for (int row = 0; row < 4; ++row) {
            int y0 = row * this.binary.width / 4;
            int y1 = (row + 1) * this.binary.width / 4;
            for (int col = 0; col < 4; ++col) {
                int x0 = col * this.binary.width / 4;
                int x1 = (col + 1) * this.binary.width / 4;
                int total = 0;
                for (int i = y0; i < y1; ++i) {
                    int index = i * this.binary.width + x0;
                    for (int j = x0; j < x1; ++j) {
                        total += this.binary.data[index++];
                    }
                }
                this.counts[row * 4 + col] = total;
            }
        }
    }
}

