/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.color;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.feature.color.FHistogramNormalized;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class FHistogramOps {
    public void histogram_U8(ImageUInt8 image, int maxPixelValue, int x0, int y0, int x1, int y1, FHistogramNormalized output) {
        int numValues = maxPixelValue + 1;
        for (int y = y0; y < y1; ++y) {
            int index = image.startIndex + y * image.stride + x0;
            int x = x0;
            while (x < x1) {
                int bin;
                int value = image.data[index] & 0xFF;
                int n = bin = output.numBins * value / numValues;
                output.hist[n] = output.hist[n] + 1.0f;
                ++x;
                ++index;
            }
        }
        float total = (x1 - x0) * (y1 - y0);
        int i = 0;
        while (i < output.hist.length) {
            int n = i++;
            output.hist[n] = output.hist[n] / total;
        }
    }

    public void histogram_U8(MultiSpectral<ImageUInt8> image, int maxPixelValue, int x0, int y0, int x1, int y1, FHistogramNormalized output) {
        int numValues = maxPixelValue + 1;
        for (int y = y0; y < y1; ++y) {
            int index = image.startIndex + y * image.stride + x0;
            int x = x0;
            while (x < x1) {
                int indexBin = 0;
                int binStride = 1;
                for (int i = 0; i < image.getNumBands(); ++i) {
                    ImageUInt8 band = (ImageUInt8)image.getBand(i);
                    int value = band.data[index] & 0xFF;
                    int bin = output.numBins * value / numValues;
                    indexBin += bin * binStride;
                    binStride *= output.numBins;
                }
                int n = indexBin;
                output.hist[n] = output.hist[n] + 1.0f;
                ++x;
                ++index;
            }
        }
        float total = (x1 - x0) * (y1 - y0);
        int i = 0;
        while (i < output.hist.length) {
            int n = i++;
            output.hist[n] = output.hist[n] / total;
        }
    }

    public void histogram_RGB_to_HS_U8(MultiSpectral<ImageUInt8> image, int x0, int y0, int x1, int y1, float minimumValue, float[] hsv, FHistogramNormalized output) {
        float sizeH = (float)(6.314601233715483 / (double)output.numBins);
        float sizeS = 1.01f / (float)output.numBins;
        ImageUInt8 imageRed = (ImageUInt8)image.getBand(0);
        ImageUInt8 imageGreen = (ImageUInt8)image.getBand(1);
        ImageUInt8 imageBlue = (ImageUInt8)image.getBand(2);
        float total = 0.0f;
        for (int y = y0; y < y1; ++y) {
            int index = image.startIndex + y * image.stride + x0;
            int x = x0;
            while (x < x1) {
                int r = imageRed.data[index] & 0xFF;
                int g = imageGreen.data[index] & 0xFF;
                int b = imageBlue.data[index] & 0xFF;
                ColorHsv.rgbToHsv((float)r, (float)g, (float)b, (float[])hsv);
                if (!(hsv[2] < minimumValue)) {
                    int binH = (int)(hsv[0] / sizeH);
                    int binS = (int)(hsv[1] / sizeS);
                    int n = binH * output.numBins + binS;
                    output.hist[n] = output.hist[n] + 1.0f;
                    total += 1.0f;
                }
                ++x;
                ++index;
            }
        }
        int i = 0;
        while (i < output.hist.length) {
            int n = i++;
            output.hist[n] = output.hist[n] / total;
        }
    }
}

