/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.predictions;

import adams.data.weka.predictions.AbstractErrorScaler;
import adams.data.weka.predictions.RelativeNumericErrorScaler;
import java.util.ArrayList;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;

public class AutoScaler
extends AbstractErrorScaler {
    private static final long serialVersionUID = 1719519275224776613L;
    protected AbstractErrorScaler m_Scaler;

    public String globalInfo() {
        return "Applies the specified numeric scaler to the data in case of a numeric class attribute, otherwise just passes on the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scaler", "scaler", (Object)new RelativeNumericErrorScaler());
    }

    public void setScaler(AbstractErrorScaler value) {
        if (value.getCapabilities().handles(Capabilities.Capability.NUMERIC_CLASS)) {
            this.m_Scaler = value;
            this.reset();
        } else {
            this.getLogger().severe("Scaler does not handle numeric attributes, ignored!");
        }
    }

    public AbstractErrorScaler getScaler() {
        return this.m_Scaler;
    }

    public String scalerTipText() {
        return "The scaler to use for numeric data.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllClasses();
        return result;
    }

    @Override
    public ArrayList<Integer> scale(ArrayList data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (data.size() > 0) {
            if (data.get(0) instanceof Double) {
                result = this.m_Scaler.scale(data);
            } else {
                result.addAll(data);
            }
        }
        return result;
    }
}

