/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.EnumWithCustomDisplay;
import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.AbstractOption;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class WekaThresholdCurve
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected ThresholdVisualizePanel m_VisualizePanel;
    protected Range m_ClassLabelRange;
    protected AttributeName m_AttributeX;
    protected AttributeName m_AttributeY;

    public String globalInfo() {
        return "Actor for displaying threshold curves, like ROC or precision/recall.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classLabelRange", (Object)new Range("first"));
        this.m_OptionManager.add("attribute-x", "attributeX", (Object)AttributeName.FP_RATE);
        this.m_OptionManager.add("attribute-y", "attributeY", (Object)AttributeName.TP_RATE);
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassLabelRange = new Range("first");
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setClassLabelRange(Range value) {
        this.m_ClassLabelRange = value;
        this.reset();
    }

    public Range getClassLabelRange() {
        return this.m_ClassLabelRange;
    }

    public String classLabelRangeTipText() {
        return "The indices of the class labels to use for the plot.";
    }

    public void setAttributeX(AttributeName value) {
        this.m_AttributeX = value;
        this.reset();
    }

    public AttributeName getAttributeX() {
        return this.m_AttributeX;
    }

    public String attributeXTipText() {
        return "The attribute to show on the X axis.";
    }

    public void setAttributeY(AttributeName value) {
        this.m_AttributeY = value;
        this.reset();
    }

    public AttributeName getAttributeY() {
        return this.m_AttributeY;
    }

    public String attributeYTipText() {
        return "The attribute to show on the Y axis.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classLabelRange", (Object)this.m_ClassLabelRange, (String)", class label: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeX", (Object)((Object)this.m_AttributeX), (String)", x-axis: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeY", (Object)((Object)this.m_AttributeY), (String)", y-axis: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new ThresholdVisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            int[] indices;
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            this.m_ClassLabelRange.setMax(eval.getHeader().classAttribute().numValues());
            for (int index : indices = this.m_ClassLabelRange.getIntIndices()) {
                ThresholdCurve curve = new ThresholdCurve();
                Instances data = curve.getCurve(eval.predictions(), index);
                PlotData2D plot = new PlotData2D(data);
                plot.setPlotName(eval.getHeader().classAttribute().value(index));
                plot.m_displayAllPoints = true;
                boolean[] connectPoints = new boolean[data.numInstances()];
                for (int cp = 1; cp < connectPoints.length; ++cp) {
                    connectPoints[cp] = true;
                }
                plot.setConnectPoints(connectPoints);
                this.m_VisualizePanel.addPlot(plot);
                if (data.attribute(this.m_AttributeX.toDisplay()) != null) {
                    this.m_VisualizePanel.setXIndex(data.attribute(this.m_AttributeX.toDisplay()).index());
                }
                if (data.attribute(this.m_AttributeY.toDisplay()) == null) continue;
                this.m_VisualizePanel.setYIndex(data.attribute(this.m_AttributeY.toDisplay()).index());
            }
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
    }

    protected Evaluation getEvaluation(Token token) {
        if (token == null) {
            return null;
        }
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = token != null ? "Threshold curve (" + this.getEvaluation(token).getHeader().relationName() + ")" : "Threshold curve";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -7362768698548152899L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    int[] indices;
                    Evaluation eval = WekaThresholdCurve.this.getEvaluation(token);
                    WekaThresholdCurve.this.m_ClassLabelRange.setMax(eval.getHeader().classAttribute().numValues());
                    for (int index : indices = WekaThresholdCurve.this.m_ClassLabelRange.getIntIndices()) {
                        ThresholdCurve curve = new ThresholdCurve();
                        Instances data = curve.getCurve(eval.predictions(), index);
                        PlotData2D plot = new PlotData2D(data);
                        plot.setPlotName(eval.getHeader().classAttribute().value(index));
                        plot.m_displayAllPoints = true;
                        boolean[] connectPoints = new boolean[data.numInstances()];
                        for (int cp = 1; cp < connectPoints.length; ++cp) {
                            connectPoints[cp] = true;
                        }
                        plot.setConnectPoints(connectPoints);
                        this.m_VisualizePanel.addPlot(plot);
                        if (data.attribute(WekaThresholdCurve.this.m_AttributeX.toDisplay()) != null) {
                            this.m_VisualizePanel.setXIndex(data.attribute(WekaThresholdCurve.this.m_AttributeX.toDisplay()).index());
                        }
                        if (data.attribute(WekaThresholdCurve.this.m_AttributeY.toDisplay()) == null) continue;
                        this.m_VisualizePanel.setYIndex(data.attribute(WekaThresholdCurve.this.m_AttributeY.toDisplay()).index());
                    }
                }
                catch (Exception e) {
                    WekaThresholdCurve.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }

    public static enum AttributeName implements EnumWithCustomDisplay<AttributeName>
    {
        TRUE_POS("True Positives"),
        FALSE_NEG("False Negatives"),
        FALSE_POS("False Positives"),
        TRUE_NEG("True Negatives"),
        FP_RATE("False Positive Rate"),
        TP_RATE("True Positive Rate"),
        PRECISION("Precision"),
        RECALL("Recall"),
        FALLOUT("Fallout"),
        FMEASURE("FMeasure"),
        SAMPLE_SIZE("Sample Size"),
        LIFT("Lift"),
        THRESHOLD("Threshold");

        private String m_Display;
        private String m_Raw;

        private AttributeName(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public AttributeName parse(String s) {
            return AttributeName.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((AttributeName)((Object)object)).toRaw();
        }

        public static AttributeName valueOf(AbstractOption option, String str) {
            AttributeName result = null;
            try {
                result = AttributeName.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (AttributeName dt : AttributeName.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

