/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JComponent;
import weka.core.Drawable;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;

public class WekaTreeVisualizer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1970232977500522747L;

    public String globalInfo() {
        return "Displays trees in dot notation. These trees get generated, for instance, by decision trees such as J48.\nEither displays the contents of a file or an object that implements " + Drawable.class.getName() + " and generates trees.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, Drawable.class, WekaModelContainer.class};
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel();
        result.setLayout((LayoutManager)new BorderLayout());
        return result;
    }

    public void clearPanel() {
        this.m_Panel.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeVisualizer createTreeVisualizer(Token token) {
        Reader reader;
        TreeVisualizer result = null;
        try {
            Object input = token.getPayload();
            if (input instanceof WekaModelContainer) {
                input = ((WekaModelContainer)((Object)input)).getValue("Model");
            }
            if (input instanceof String) {
                reader = new StringReader((String)input);
            } else if (input instanceof File) {
                reader = new BufferedReader(new FileReader(((File)input).getAbsolutePath()));
            } else {
                if (((Drawable)input).graphType() != 1) {
                    throw new IllegalArgumentException(token.getPayload().getClass().getName() + " does not generate a tree!");
                }
                reader = new StringReader(((Drawable)input).graph());
            }
        }
        catch (Exception e) {
            this.handleException("Failed to instantiate reader for input!", e);
            return result;
        }
        TreeBuild builder = new TreeBuild();
        Node top = null;
        PlaceNode2 arrange = new PlaceNode2();
        try {
            top = builder.create(reader);
            result = new TreeVisualizer(null, top, (NodePlace)arrange);
        }
        catch (Exception e) {
            this.handleException("Failed to parse dot notation!", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected void display(Token token) {
        this.clearPanel();
        TreeVisualizer visualizer = this.createTreeVisualizer(token);
        if (visualizer != null) {
            this.m_Panel.add((Component)visualizer, (Object)"Center");
        }
    }

    public JComponent supplyComponent() {
        return (TreeVisualizer)GUIHelper.findFirstComponent((Container)this.m_Panel, TreeVisualizer.class, (boolean)true, (boolean)true);
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected TreeVisualizer m_Visualizer;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
            }

            public void display(Token token) {
                this.m_Visualizer = WekaTreeVisualizer.this.createTreeVisualizer(token);
                this.add((Component)this.m_Visualizer, "Center");
            }

            public void cleanUp() {
            }

            public void clearPanel() {
                this.removeAll();
            }

            public JComponent supplyComponent() {
                return this.m_Visualizer;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

