/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.edit;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPageContentStream {
    private static final Log LOG = LogFactory.getLog(PDPageContentStream.class);
    private PDPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private PDResources resources;
    private PDColorSpace currentStrokingColorSpace = new PDDeviceGray();
    private PDColorSpace currentNonStrokingColorSpace = new PDDeviceGray();
    private float[] colorComponents = new float[4];
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private static final String ISO8859 = "ISO-8859-1";
    private static final byte[] BEGIN_TEXT = PDPageContentStream.getISOBytes("BT\n");
    private static final byte[] END_TEXT = PDPageContentStream.getISOBytes("ET\n");
    private static final byte[] SET_FONT = PDPageContentStream.getISOBytes("Tf\n");
    private static final byte[] MOVE_TEXT_POSITION = PDPageContentStream.getISOBytes("Td\n");
    private static final byte[] SET_TEXT_MATRIX = PDPageContentStream.getISOBytes("Tm\n");
    private static final byte[] SHOW_TEXT = PDPageContentStream.getISOBytes("Tj\n");
    private static final byte[] SAVE_GRAPHICS_STATE = PDPageContentStream.getISOBytes("q\n");
    private static final byte[] RESTORE_GRAPHICS_STATE = PDPageContentStream.getISOBytes("Q\n");
    private static final byte[] CONCATENATE_MATRIX = PDPageContentStream.getISOBytes("cm\n");
    private static final byte[] XOBJECT_DO = PDPageContentStream.getISOBytes("Do\n");
    private static final byte[] RG_STROKING = PDPageContentStream.getISOBytes("RG\n");
    private static final byte[] RG_NON_STROKING = PDPageContentStream.getISOBytes("rg\n");
    private static final byte[] K_STROKING = PDPageContentStream.getISOBytes("K\n");
    private static final byte[] K_NON_STROKING = PDPageContentStream.getISOBytes("k\n");
    private static final byte[] G_STROKING = PDPageContentStream.getISOBytes("G\n");
    private static final byte[] G_NON_STROKING = PDPageContentStream.getISOBytes("g\n");
    private static final byte[] RECTANGLE = PDPageContentStream.getISOBytes("re\n");
    private static final byte[] FILL_NON_ZERO = PDPageContentStream.getISOBytes("f\n");
    private static final byte[] FILL_EVEN_ODD = PDPageContentStream.getISOBytes("f*\n");
    private static final byte[] LINE_TO = PDPageContentStream.getISOBytes("l\n");
    private static final byte[] MOVE_TO = PDPageContentStream.getISOBytes("m\n");
    private static final byte[] CLOSE_STROKE = PDPageContentStream.getISOBytes("s\n");
    private static final byte[] STROKE = PDPageContentStream.getISOBytes("S\n");
    private static final byte[] LINE_WIDTH = PDPageContentStream.getISOBytes("w\n");
    private static final byte[] LINE_JOIN_STYLE = PDPageContentStream.getISOBytes("j\n");
    private static final byte[] LINE_CAP_STYLE = PDPageContentStream.getISOBytes("J\n");
    private static final byte[] LINE_DASH_PATTERN = PDPageContentStream.getISOBytes("d\n");
    private static final byte[] CLOSE_SUBPATH = PDPageContentStream.getISOBytes("h\n");
    private static final byte[] CLIP_PATH_NON_ZERO = PDPageContentStream.getISOBytes("W\n");
    private static final byte[] CLIP_PATH_EVEN_ODD = PDPageContentStream.getISOBytes("W*\n");
    private static final byte[] NOP = PDPageContentStream.getISOBytes("n\n");
    private static final byte[] BEZIER_312 = PDPageContentStream.getISOBytes("c\n");
    private static final byte[] BEZIER_32 = PDPageContentStream.getISOBytes("v\n");
    private static final byte[] BEZIER_313 = PDPageContentStream.getISOBytes("y\n");
    private static final byte[] BMC = PDPageContentStream.getISOBytes("BMC\n");
    private static final byte[] BDC = PDPageContentStream.getISOBytes("BDC\n");
    private static final byte[] EMC = PDPageContentStream.getISOBytes("EMC\n");
    private static final byte[] SET_STROKING_COLORSPACE = PDPageContentStream.getISOBytes("CS\n");
    private static final byte[] SET_NON_STROKING_COLORSPACE = PDPageContentStream.getISOBytes("cs\n");
    private static final byte[] SET_STROKING_COLOR_SIMPLE = PDPageContentStream.getISOBytes("SC\n");
    private static final byte[] SET_STROKING_COLOR_COMPLEX = PDPageContentStream.getISOBytes("SCN\n");
    private static final byte[] SET_NON_STROKING_COLOR_SIMPLE = PDPageContentStream.getISOBytes("sc\n");
    private static final byte[] SET_NON_STROKING_COLOR_COMPLEX = PDPageContentStream.getISOBytes("scn\n");
    private static final byte[] OPENING_BRACKET = PDPageContentStream.getISOBytes("[");
    private static final byte[] CLOSING_BRACKET = PDPageContentStream.getISOBytes("]");
    private static final int SPACE = 32;

    private static byte[] getISOBytes(String s) {
        try {
            return s.getBytes(ISO8859);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, false, true);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress, boolean resetContext) throws IOException {
        PDStream contents;
        boolean hasContent;
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        boolean bl = hasContent = (contents = sourcePage.getContents()) != null;
        if (appendContent && hasContent) {
            PDStream contentsToAppend = new PDStream(document);
            COSStreamArray compoundStream = null;
            if (contents.getStream() instanceof COSStreamArray) {
                compoundStream = (COSStreamArray)contents.getStream();
                compoundStream.appendStream(contentsToAppend.getStream());
            } else {
                COSArray newArray = new COSArray();
                newArray.add(contents.getCOSObject());
                newArray.add(contentsToAppend.getCOSObject());
                compoundStream = new COSStreamArray(newArray);
            }
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contentsToAppend.setFilters(filters);
            }
            if (resetContext) {
                PDStream saveGraphics = new PDStream(document);
                this.output = saveGraphics.createOutputStream();
                this.saveGraphicsState();
                this.close();
                if (compress) {
                    ArrayList<COSName> filters = new ArrayList<COSName>();
                    filters.add(COSName.FLATE_DECODE);
                    saveGraphics.setFilters(filters);
                }
                compoundStream.insertCOSStream(saveGraphics);
            }
            sourcePage.setContents(new PDStream(compoundStream));
            this.output = contentsToAppend.createOutputStream();
            if (resetContext) {
                this.restoreGraphicsState();
            }
        } else {
            if (hasContent) {
                LOG.warn((Object)"You are overwriting an existing content, you should use the append mode");
            }
            contents = new PDStream(document);
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contents.setFilters(filters);
            }
            sourcePage.setContents(contents);
            this.output = contents.createOutputStream();
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.appendRawCommands(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.appendRawCommands(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = this.resources.addFont(font);
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(fontSize);
        this.appendRawCommands(32);
        this.appendRawCommands(SET_FONT);
    }

    public void drawImage(PDXObjectImage image, float x, float y) throws IOException {
        this.drawXObject(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawXObject(PDXObject xobject, float x, float y, float width, float height) throws IOException {
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.drawXObject(xobject, transform);
    }

    public void drawXObject(PDXObject xobject, AffineTransform transform) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawXObject is not allowed within a text block.");
        }
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof PDXObjectImage ? "Im" : "Form";
        String objMapping = this.resources.addXObject(xobject, xObjectPrefix);
        this.saveGraphicsState();
        this.appendRawCommands(32);
        this.concatenate2CTM(transform);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(XOBJECT_DO);
        this.restoreGraphicsState();
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before moveTextPositionByAmount");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TEXT_POSITION);
    }

    public void setTextMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendRawCommands(a);
        this.appendRawCommands(32);
        this.appendRawCommands(b);
        this.appendRawCommands(32);
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(d);
        this.appendRawCommands(32);
        this.appendRawCommands(e);
        this.appendRawCommands(32);
        this.appendRawCommands(f);
        this.appendRawCommands(32);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextMatrix(AffineTransform matrix) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendMatrix(matrix);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextScaling(double sx, double sy, double tx, double ty) throws IOException {
        this.setTextMatrix(sx, 0.0, 0.0, sy, tx, ty);
    }

    public void setTextTranslation(double tx, double ty) throws IOException {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public void setTextRotation(double angle, double tx, double ty) throws IOException {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        this.setTextMatrix(angleCos, angleSin, -angleSin, angleCos, tx, ty);
    }

    public void concatenate2CTM(double a, double b, double c, double d, double e, double f) throws IOException {
        this.appendRawCommands(a);
        this.appendRawCommands(32);
        this.appendRawCommands(b);
        this.appendRawCommands(32);
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(d);
        this.appendRawCommands(32);
        this.appendRawCommands(e);
        this.appendRawCommands(32);
        this.appendRawCommands(f);
        this.appendRawCommands(32);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void concatenate2CTM(AffineTransform at) throws IOException {
        this.appendMatrix(at);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void drawString(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before drawString");
        }
        COSString string = new COSString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(buffer.toByteArray());
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_STROKING_COLORSPACE);
    }

    public void setNonStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentNonStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_NON_STROKING_COLORSPACE);
    }

    private void writeColorSpace(PDColorSpace colorSpace) throws IOException {
        COSName key = null;
        if (colorSpace instanceof PDDeviceGray || colorSpace instanceof PDDeviceRGB || colorSpace instanceof PDDeviceCMYK) {
            key = COSName.getPDFName(colorSpace.getName());
        } else {
            COSDictionary colorSpaces = (COSDictionary)this.resources.getCOSDictionary().getDictionaryObject(COSName.COLORSPACE);
            if (colorSpaces == null) {
                colorSpaces = new COSDictionary();
                this.resources.getCOSDictionary().setItem(COSName.COLORSPACE, (COSBase)colorSpaces);
            }
            if ((key = colorSpaces.getKeyForValue(colorSpace.getCOSObject())) == null) {
                int counter = 0;
                String csName = "CS";
                while (colorSpaces.containsValue(csName + counter)) {
                    ++counter;
                }
                key = COSName.getPDFName(csName + counter);
                colorSpaces.setItem(key, (COSObjectable)colorSpace);
            }
        }
        key.writePDF(this.output);
        this.appendRawCommands(32);
    }

    public void setStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(components[i]);
            this.appendRawCommands(32);
        }
        if (this.currentStrokingColorSpace instanceof PDSeparation || this.currentStrokingColorSpace instanceof PDPattern || this.currentStrokingColorSpace instanceof PDDeviceN || this.currentStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_STROKING_COLOR_SIMPLE);
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands((double)r / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)b / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(RG_STROKING);
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands((double)c / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)m / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)y / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)k / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(m);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(k);
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(g);
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setNonStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(components[i]);
            this.appendRawCommands(32);
        }
        if (this.currentNonStrokingColorSpace instanceof PDSeparation || this.currentNonStrokingColorSpace instanceof PDPattern || this.currentNonStrokingColorSpace instanceof PDDeviceN || this.currentNonStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_NON_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_NON_STROKING_COLOR_SIMPLE);
        }
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands((double)r / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)b / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(RG_NON_STROKING);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands((double)c / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)m / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)y / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)k / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(m);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(k);
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(int g) throws IOException {
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(g);
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addRect is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(width);
        this.appendRawCommands(32);
        this.appendRawCommands(height);
        this.appendRawCommands(32);
        this.appendRawCommands(RECTANGLE);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fillRect is not allowed within a text block.");
        }
        this.addRect(x, y, width, height);
        this.fill(1);
    }

    public void addBezier312(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier312 is not allowed within a text block.");
        }
        this.appendRawCommands(x1);
        this.appendRawCommands(32);
        this.appendRawCommands(y1);
        this.appendRawCommands(32);
        this.appendRawCommands(x2);
        this.appendRawCommands(32);
        this.appendRawCommands(y2);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_312);
    }

    public void addBezier32(float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier32 is not allowed within a text block.");
        }
        this.appendRawCommands(x2);
        this.appendRawCommands(32);
        this.appendRawCommands(y2);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_32);
    }

    public void addBezier31(float x1, float y1, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier31 is not allowed within a text block.");
        }
        this.appendRawCommands(x1);
        this.appendRawCommands(32);
        this.appendRawCommands(y1);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_313);
    }

    public void moveTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: moveTo is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
    }

    public void lineTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: lineTo is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
    }

    public void addLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addLine is not allowed within a text block.");
        }
        this.moveTo(xStart, yStart);
        this.lineTo(xEnd, yEnd);
    }

    public void drawLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawLine is not allowed within a text block.");
        }
        this.addLine(xStart, yStart, xEnd, yEnd);
        this.stroke();
    }

    public void addPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addPolygon is not allowed within a text block.");
        }
        if (x.length != y.length) {
            throw new IOException("Error: some points are missing coordinate");
        }
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                this.moveTo(x[i], y[i]);
                continue;
            }
            this.lineTo(x[i], y[i]);
        }
        this.closeSubPath();
    }

    public void drawPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.stroke();
    }

    public void fillPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fillPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.fill(1);
    }

    public void stroke() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: stroke is not allowed within a text block.");
        }
        this.appendRawCommands(STROKE);
    }

    public void closeAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: closeAndStroke is not allowed within a text block.");
        }
        this.appendRawCommands(CLOSE_STROKE);
    }

    public void fill(int windingRule) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fill is not allowed within a text block.");
        }
        if (windingRule == 1) {
            this.appendRawCommands(FILL_NON_ZERO);
        } else if (windingRule == 0) {
            this.appendRawCommands(FILL_EVEN_ODD);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void closeSubPath() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: closeSubPath is not allowed within a text block.");
        }
        this.appendRawCommands(CLOSE_SUBPATH);
    }

    public void clipPath(int windingRule) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: clipPath is not allowed within a text block.");
        }
        if (windingRule == 1) {
            this.appendRawCommands(CLIP_PATH_NON_ZERO);
            this.appendRawCommands(NOP);
        } else if (windingRule == 0) {
            this.appendRawCommands(CLIP_PATH_EVEN_ODD);
            this.appendRawCommands(NOP);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void setLineWidth(float lineWidth) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineWidth is not allowed within a text block.");
        }
        this.appendRawCommands(lineWidth);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_WIDTH);
    }

    public void setLineJoinStyle(int lineJoinStyle) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineJoinStyle is not allowed within a text block.");
        }
        if (lineJoinStyle < 0 || lineJoinStyle > 2) {
            throw new IOException("Error: unknown value for line join style");
        }
        this.appendRawCommands(Integer.toString(lineJoinStyle));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_JOIN_STYLE);
    }

    public void setLineCapStyle(int lineCapStyle) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineCapStyle is not allowed within a text block.");
        }
        if (lineCapStyle < 0 || lineCapStyle > 2) {
            throw new IOException("Error: unknown value for line cap style");
        }
        this.appendRawCommands(Integer.toString(lineCapStyle));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_CAP_STYLE);
    }

    public void setLineDashPattern(float[] pattern, float phase) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineDashPattern is not allowed within a text block.");
        }
        this.appendRawCommands(OPENING_BRACKET);
        for (float value : pattern) {
            this.appendRawCommands(value);
            this.appendRawCommands(32);
        }
        this.appendRawCommands(CLOSING_BRACKET);
        this.appendRawCommands(32);
        this.appendRawCommands(phase);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_DASH_PATTERN);
    }

    public void beginMarkedContentSequence(COSName tag) throws IOException {
        this.appendCOSName(tag);
        this.appendRawCommands(32);
        this.appendRawCommands(BMC);
    }

    public void beginMarkedContentSequence(COSName tag, COSName propsName) throws IOException {
        this.appendCOSName(tag);
        this.appendRawCommands(32);
        this.appendCOSName(propsName);
        this.appendRawCommands(32);
        this.appendRawCommands(BDC);
    }

    public void endMarkedContentSequence() throws IOException {
        this.appendRawCommands(EMC);
    }

    public void saveGraphicsState() throws IOException {
        this.appendRawCommands(SAVE_GRAPHICS_STATE);
    }

    public void restoreGraphicsState() throws IOException {
        this.appendRawCommands(RESTORE_GRAPHICS_STATE);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes(ISO8859));
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.output.write(commands);
    }

    public void appendRawCommands(int data) throws IOException {
        this.output.write(data);
    }

    public void appendRawCommands(double data) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(data));
    }

    public void appendRawCommands(float data) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(data));
    }

    public void appendCOSName(COSName name) throws IOException {
        name.writePDF(this.output);
    }

    private void appendMatrix(AffineTransform transform) throws IOException {
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.appendRawCommands(v);
            this.appendRawCommands(32);
        }
    }

    public void close() throws IOException {
        this.output.close();
        this.currentNonStrokingColorSpace = null;
        this.currentStrokingColorSpace = null;
        this.page = null;
        this.resources = null;
    }
}

