/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BasePassword;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import java.util.logging.Level;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

@MixedCopyright(copyright="Apache Software Foundation", license=License.APACHE2, url="http://commons.apache.org/proper/commons-email/userguide.html")
public class SimpleApacheSendEmail
extends AbstractSendEmail {
    private static final long serialVersionUID = 4065886204614191616L;
    protected String m_Server;
    protected int m_Port;
    protected boolean m_UseTLS;
    protected boolean m_UseSSL;
    protected int m_Timeout;
    protected boolean m_RequiresAuth;
    protected String m_User;
    protected BasePassword m_Password;

    public String globalInfo() {
        return "Uses the Apache commons-email library to send emails.";
    }

    @Override
    public boolean requiresSmtpSessionInitialization() {
        return true;
    }

    @Override
    public void initializeSmtpSession(String server, int port, boolean useTLS, boolean useSSL, int timeout, boolean requiresAuth, String user, BasePassword pw) throws Exception {
        this.m_Server = server;
        this.m_Port = port;
        this.m_UseTLS = useTLS;
        this.m_UseSSL = useSSL;
        this.m_Timeout = timeout;
        this.m_RequiresAuth = requiresAuth;
        this.m_User = user;
        this.m_Password = pw;
    }

    @Override
    public boolean sendMail(Email email) throws Exception {
        Object mail = email.getAttachments().length > 0 ? new MultiPartEmail() : new SimpleEmail();
        mail.setFrom(email.getFrom().getValue());
        for (EmailAddress address : email.getTo()) {
            mail.addTo(address.getValue());
        }
        for (EmailAddress address : email.getCC()) {
            mail.addCc(address.getValue());
        }
        for (EmailAddress address : email.getBCC()) {
            mail.addBcc(address.getValue());
        }
        mail.setSubject(email.getSubject());
        mail.setMsg(email.getBody());
        mail.setHostName(this.m_Server);
        mail.setSmtpPort(this.m_Port);
        mail.setStartTLSEnabled(this.m_UseTLS);
        mail.setSSLOnConnect(this.m_UseSSL);
        if (this.m_RequiresAuth) {
            mail.setAuthentication(this.m_User, this.m_Password.getValue());
        }
        mail.setSocketTimeout(this.m_Timeout);
        try {
            String id = mail.send();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Message sent: " + id);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to send email: " + mail, e);
            return false;
        }
        return true;
    }
}

