/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.cc.CNode;
import meka.core.A;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class CC
extends MultilabelClassifier
implements Randomizable,
TechnicalInformationHandler {
    protected CNode[] nodes = null;
    protected int m_S = 0;
    protected Random m_R = null;
    protected int[] m_Chain = null;
    protected double[] confidences = null;

    public void setSeed(int s) {
        this.m_S = s;
    }

    public int getSeed() {
        return this.m_S;
    }

    public void setChain(int[] chain) {
        this.m_Chain = Arrays.copyOf(chain, chain.length);
    }

    public int[] getChain() {
        return this.m_Chain;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        this.m_R = new Random(this.m_S);
        int[] indices = this.getChain();
        if (indices == null) {
            indices = A.make_sequence(L);
            MLUtils.randomize(indices, this.m_R);
            this.setChain(indices);
            if (this.getDebug()) {
                System.out.println("Chain s=" + Arrays.toString(indices));
            }
        }
        if (this.getDebug()) {
            System.out.print(":- Chain (");
        }
        this.nodes = new CNode[L];
        int[] pa = new int[]{};
        for (int j : this.m_Chain) {
            if (this.getDebug()) {
                System.out.print(" " + D.attribute(j).name());
            }
            this.nodes[j] = new CNode(j, null, pa);
            this.nodes[j].build(D, this.m_Classifier);
            pa = A.append(pa, j);
        }
        if (this.getDebug()) {
            System.out.println(" ) -:");
        }
        this.confidences = new double[L];
    }

    public double[] getConfidences() {
        return this.confidences;
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        double[] y = new double[L];
        for (int j : this.m_Chain) {
            y[j] = this.nodes[j].classify((Instance)x.copy(), y);
        }
        return y;
    }

    public double[] sampleForInstance(Instance x, Random r) throws Exception {
        int L = x.classIndex();
        double[] y = new double[L];
        for (int j : this.m_Chain) {
            double[] p = this.nodes[j].distribution(x, y);
            y[j] = A.samplePMF(p, r);
            this.confidences[j] = p[(int)y[j]];
        }
        return y;
    }

    public Instance[] getTransformTemplates(Instance x) throws Exception {
        int L = x.classIndex();
        Instance[] t_ = new Instance[L];
        double[] ypred = new double[L];
        for (int j : this.m_Chain) {
            t_[j] = this.nodes[j].transform(x, ypred);
        }
        return t_;
    }

    public double[] sampleForInstanceFast(Instance[] t_, Random r) throws Exception {
        int L = t_.length;
        double[] y = new double[L];
        for (int j : this.m_Chain) {
            double[] p = this.nodes[j].distributionT(t_[j]);
            y[j] = A.samplePMF(p, r);
            this.confidences[j] = p[(int)y[j]];
        }
        return y;
    }

    public Instance[] transformInstance(Instance x) throws Exception {
        return null;
    }

    public double[] probabilityForInstance(Instance x, double[] path) throws Exception {
        int L = x.classIndex();
        double[] p = new double[L];
        for (int j : this.m_Chain) {
            double[] d = this.nodes[j].distribution((Instance)x.copy(), path);
            int k = (int)Math.round(path[j]);
            p[j] = d[k];
        }
        return p;
    }

    public void rebuildClassifier(int[] nchain, Instances D) throws Exception {
    }

    @Override
    public String globalInfo() {
        return "The Classifier Chains Method.For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        additional.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "20th European Conference on Machine Learning (ECML 2009). Bled, Slovenia, September 2009");
        additional.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.add(additional);
        return result;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CC(), args);
    }
}

