/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import java.util.Random;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.IncrementalEvaluation;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class CCUpdateable
extends CC
implements UpdateableClassifier {
    private static final long serialVersionUID = 2856976982562474367L;
    protected ULink root = null;

    @Override
    public String globalInfo() {
        return "Updateable CC\nMust be run with an Updateable base classifier.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int[] indices = this.getChain();
        if (indices == null) {
            indices = MLUtils.gen_indices(L);
            MLUtils.randomize(indices, new Random(this.m_S));
        }
        if (this.getDebug()) {
            System.out.print(":- Chain (");
        }
        this.root = new ULink(indices, 0, D);
        if (this.getDebug()) {
            System.out.println(" ) -:");
        }
    }

    public void updateClassifier(Instance x) throws Exception {
        if (this.root == null) {
            throw new Exception("Train to update chain, but chain not build yet");
        }
        this.root.update(x);
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        this.root.classify(x);
        return MLUtils.toDoubleArray(x, L);
    }

    public static void main(String[] args) {
        IncrementalEvaluation.runExperiment(new CCUpdateable(), args);
    }

    protected class ULink {
        private ULink next = null;
        private AbstractClassifier classifier = null;
        public Instances _template = null;
        private int index = -1;
        private int value = -1;
        private int[] excld;
        private int j = 0;

        public ULink(int[] chain, int j, Instances train) throws Exception {
            this.j = j;
            this.index = chain[j];
            this.excld = Arrays.copyOfRange(chain, j + 1, chain.length);
            Arrays.sort(this.excld);
            this.classifier = (AbstractClassifier)AbstractClassifier.forName((String)CCUpdateable.this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)CCUpdateable.this.getClassifier()).getOptions());
            Instances new_train = new Instances(train);
            if (CCUpdateable.this.getDebug()) {
                System.out.print(" " + this.index);
            }
            new_train.setClassIndex(-1);
            int c_index = this.value = chain[j];
            for (int i = this.excld.length - 1; i >= 0; --i) {
                new_train.deleteAttributeAt(this.excld[i]);
                if (this.excld[i] >= this.index) continue;
                --c_index;
            }
            new_train.setClassIndex(c_index);
            this._template = new Instances(new_train, 0);
            this.classifier.buildClassifier(new_train);
            new_train = null;
            if (j + 1 < chain.length) {
                this.next = new ULink(chain, ++j, train);
            }
        }

        protected void update(Instance x) throws Exception {
            Instance x_ = (Instance)x.copy();
            x_.setDataset(null);
            int c_index = this.value;
            for (int i = this.excld.length - 1; i >= 0; --i) {
                x_.deleteAttributeAt(this.excld[i]);
                if (this.excld[i] >= this.index) continue;
                --c_index;
            }
            x_.setDataset(this._template);
            ((UpdateableClassifier)this.classifier).updateClassifier(x_);
            if (this.next != null) {
                this.next.update(x);
            }
        }

        protected void classify(Instance test) throws Exception {
            Instance copy = (Instance)test.copy();
            copy.setDataset(null);
            for (int i = this.excld.length - 1; i >= 0; --i) {
                copy.deleteAttributeAt(this.excld[i]);
            }
            copy.setDataset(this._template);
            test.setValue(this.index, (double)((int)this.classifier.classifyInstance(copy)));
            if (this.next != null) {
                this.next.classify(test);
            }
        }

        public String toString() {
            return this.next == null ? String.valueOf(this.index) : String.valueOf(this.index) + ">" + this.next.toString();
        }
    }
}

