/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.List;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class FW
extends MultilabelClassifier {
    Classifier[][] h = null;
    Attribute classAttribute = null;

    @Override
    public String globalInfo() {
        return "The Fourclass Pairwise (FW) method.\nTrains a multi-class base classifier for each pair of labels -- (L*(L-1))/2 in total --, each with four possible class values: {00,01,10,11} representing the possible combinations of relevant (1) /irrelevant (0) for the pair. Uses a voting + threshold scheme at testing time where e.g., 01 from pair jk gives one vote to label k; any label with votes above the threshold is considered relevant.";
    }

    protected Instances convert(Instances D, int j, int k) {
        int i;
        int L = D.classIndex();
        D = new Instances(D);
        D.insertAttributeAt(this.classAttribute, 0);
        D.setClassIndex(0);
        for (i = 0; i < D.numInstances(); ++i) {
            String c = (int)Math.round(D.instance(i).value(j + 1)) + "" + (int)Math.round(D.instance(i).value(k + 1));
            D.instance(i).setClassValue(c);
        }
        for (i = 0; i < L; ++i) {
            D.deleteAttributeAt(1);
        }
        this.m_InstancesTemplate = new Instances(D, 0);
        return D;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        FastVector values = new FastVector(4);
        values.addElement((Object)"00");
        values.addElement((Object)"10");
        values.addElement((Object)"01");
        values.addElement((Object)"11");
        this.classAttribute = new Attribute("TheCLass", (List)values);
        int L = D.classIndex();
        this.h = new Classifier[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                if (this.getDebug()) {
                    System.out.print(".");
                }
                Instances D_pair = this.convert(D, j, k);
                this.h[j][k] = (AbstractClassifier)AbstractClassifier.forName((String)this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)this.getClassifier()).getOptions());
                this.h[j][k].buildClassifier(D_pair);
            }
            if (!this.getDebug()) continue;
            System.out.println("");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        x = (Instance)x.copy();
        x.setDataset(null);
        for (int i = 1; i < L; ++i) {
            x.deleteAttributeAt(1);
        }
        x.setDataset(this.m_InstancesTemplate);
        double[] r = new double[L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                int c = (int)Math.round(this.h[j][k].classifyInstance(x));
                if (c == 1) {
                    int n = j;
                    r[n] = r[n] + 1.0;
                }
                if (c == 2) {
                    int n = k;
                    r[n] = r[n] + 1.0;
                }
                if (c != 3) continue;
                int n = j;
                r[n] = r[n] + 1.0;
                int n2 = k;
                r[n2] = r[n2] + 1.0;
            }
        }
        return r;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new FW(), args);
    }
}

