/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.F;
import meka.core.MLUtils;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.lazy.IBLR_ML;
import mulan.classifier.lazy.MLkNN;
import mulan.classifier.meta.HOMER;
import mulan.classifier.meta.HierarchyBuilder;
import mulan.classifier.meta.RAkEL;
import mulan.classifier.neural.BPMLL;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.classifier.transformation.CalibratedLabelRanking;
import mulan.classifier.transformation.ClassifierChain;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class MULAN
extends MultilabelClassifier {
    private static final long serialVersionUID = 1720289364996202350L;
    protected MultiLabelLearner m_MULAN = null;
    private String MethodSelection = "{BR, LP, CLR, RAkELn, MLkNN, IBLR_ML, BPMLL, HOMER.type.numPartitions.pt}\n\twhere n=1 is with (m=10,k=L/2), n=2 is with (m=L*2,k=3); and\n\twhere type \\in {BalancedClustering,Clustering,Random}, pt \\in {BinaryRelevance,LabelPowerset,ClassifierChain, numPartitions \\in [1,2,3,4,...]}.";
    protected String m_MethodString = "RAkEL1";

    @Override
    public String globalInfo() {
        return "A wrapper for MULAN classifiers.\nhttp://mulan.sourceforge.net";
    }

    public void setMethod(String m) {
        this.m_MethodString = m;
    }

    public String getMethod() {
        return this.m_MethodString;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tMethod Name\n\t " + this.MethodSelection + "", "S", 1, "-S <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setMethod(Utils.getOption((char)'S', (String[])options));
        super.setOptions(options);
    }

    public String methodTipText() {
        return "Any of " + this.MethodSelection + ". If you wish to add more, you will have to add code to the buildClassifier(Instances) function in MULAN.java";
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-S";
        options[current++] = this.getMethod();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        int L;
        this.testCapabilities(instances);
        long before = System.currentTimeMillis();
        if (this.getDebug()) {
            System.err.print(" moving target attributes to the beginning ... ");
        }
        Random r = instances.getRandomNumberGenerator(0L);
        String name = "temp_" + MLUtils.getDatasetName(instances) + "_" + r.nextLong() + ".arff";
        System.err.println("Using temporary file: " + name);
        for (int i = L = instances.classIndex(); i < instances.numAttributes(); ++i) {
            instances.renameAttribute(i, "a_" + i);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(name));
        this.m_InstancesTemplate = F.meka2mulan(new Instances(instances), L);
        writer.write(this.m_InstancesTemplate.toString());
        writer.flush();
        writer.close();
        MultiLabelInstances train = new MultiLabelInstances(name, L);
        try {
            new File(name).delete();
        }
        catch (Exception e) {
            System.err.println("[Error] Failed to delete temporary file: " + name + ". You may want to delete it manually.");
        }
        if (this.getDebug()) {
            System.out.println(" done ");
        }
        long after = System.currentTimeMillis();
        System.err.println("[Note] Discount " + (double)(after - before) / 1000.0 + " seconds from this build time");
        this.m_InstancesTemplate = new Instances(train.getDataSet(), 0);
        System.out.println("CLASSIFIER " + this.m_Classifier);
        if (this.m_MethodString.equals("BR")) {
            this.m_MULAN = new BinaryRelevance(this.m_Classifier);
        } else if (this.m_MethodString.equals("LP")) {
            this.m_MULAN = new LabelPowerset(this.m_Classifier);
        } else if (this.m_MethodString.equals("CLR")) {
            this.m_MULAN = new CalibratedLabelRanking(this.m_Classifier);
        } else if (this.m_MethodString.equals("RAkEL1")) {
            this.m_MULAN = new RAkEL((MultiLabelLearner)new LabelPowerset(this.m_Classifier), 10, L / 2);
            System.out.println("m=10,k=" + L / 2);
        } else if (this.m_MethodString.equals("RAkEL2")) {
            this.m_MULAN = new RAkEL((MultiLabelLearner)new LabelPowerset(this.m_Classifier), 2 * L, 3);
            System.out.println("m=" + L * 2 + ",k=3");
        } else if (this.m_MethodString.equals("MLkNN")) {
            this.m_MULAN = new MLkNN(10, 1.0);
        } else if (this.m_MethodString.equals("IBLR_ML")) {
            this.m_MULAN = new IBLR_ML(10);
        } else if (this.m_MethodString.equals("BPMLL")) {
            this.m_MULAN = new BPMLL();
            ((BPMLL)this.m_MULAN).setLearningRate(0.01);
            ((BPMLL)this.m_MULAN).setHiddenLayers(new int[]{30});
            ((BPMLL)this.m_MULAN).setTrainingEpochs(100);
        } else if (this.m_MethodString.startsWith("HOMER")) {
            String[] ops = this.m_MethodString.split("\\.");
            int n = 3;
            try {
                n = Integer.parseInt(ops[2]);
            }
            catch (Exception e) {
                System.err.println("[Warning] Could not parse number of clusters, using default: " + n);
            }
            LabelPowerset mll = new LabelPowerset(this.m_Classifier);
            if (ops[3].equalsIgnoreCase("BinaryRelevance")) {
                mll = new BinaryRelevance(this.m_Classifier);
            } else if (ops[3].equalsIgnoreCase("ClassifierChain")) {
                mll = new ClassifierChain(this.m_Classifier);
            } else if (!ops[3].equalsIgnoreCase("LabelPowerset")) {
                System.err.println("[Warning] Did not recognise classifier type String, using default: LabelPowerset");
            }
            if (this.getDebug()) {
                System.out.println("HOMER(" + mll + "," + n + "," + ops[1] + ")");
            }
            this.m_MULAN = new HOMER((MultiLabelLearner)mll, n, HierarchyBuilder.Method.valueOf((String)ops[1]));
        } else {
            throw new Exception("Could not find MULAN Classifier by that name: " + this.m_MethodString);
        }
        this.m_MULAN.setDebug(this.getDebug());
        this.m_MULAN.build(train);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int L = instance.classIndex();
        Instance x = F.meka2mulan((Instance)instance.copy(), L);
        x.setDataset(this.m_InstancesTemplate);
        double[] y = this.m_MULAN.makePrediction(x).getConfidences();
        return y;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new MULAN(), args);
    }
}

