/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.PS;
import meka.core.MLUtils;
import meka.core.PSUtils;
import meka.core.SuperLabelUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class RAkEL
extends PS {
    private static final long serialVersionUID = -6208337124440497991L;
    protected Classifier[] m_Classifiers = null;
    protected Instances[] m_InstancesTemplates = null;
    int m_K = 3;
    int m_M = 10;
    int m_S = 0;
    protected int[][] kMap = null;

    @Override
    public String globalInfo() {
        return "Draws M subsets of size k from the set of labels, and trains PS upon each one, then combines label votes from the PS classifiers to get a label-vector prediction.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        Random r = new Random(this.m_S);
        if (this.getDebug()) {
            System.out.println("Building " + this.m_M + " models of " + this.m_K + " random subsets:");
        }
        this.m_InstancesTemplates = new Instances[this.m_M];
        this.kMap = new int[this.m_M][this.m_K];
        this.m_Classifiers = AbstractClassifier.makeCopies((Classifier)this.m_Classifier, (int)this.m_M);
        for (int i = 0; i < this.m_M; ++i) {
            this.kMap[i] = SuperLabelUtils.get_k_subset(L, this.m_K, r);
            if (this.getDebug()) {
                System.out.println("\tmodel " + (i + 1) + "/" + this.m_M + ": " + Arrays.toString(this.kMap[i]) + ", P=" + this.m_P + ", N=" + this.m_N);
            }
            Instances D_i = SuperLabelUtils.makePartitionDataset(D, this.kMap[i], this.m_P, this.m_N);
            this.m_Classifiers[i].buildClassifier(D_i);
            this.m_InstancesTemplates[i] = new Instances(D_i, 0);
        }
    }

    private int[] mapBack(Instances template, int i) {
        try {
            return MLUtils.toIntArray(template.classAttribute().value(i));
        }
        catch (Exception e) {
            return new int[0];
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        double[] y = new double[L];
        for (int m = 0; m < this.m_M; ++m) {
            int[] k_indices;
            Instance x_m = PSUtils.convertInstance(x, L, this.m_InstancesTemplates[m]);
            x_m.setDataset(this.m_InstancesTemplates[m]);
            int i_m = (int)this.m_Classifiers[m].classifyInstance(x_m);
            for (int i : k_indices = this.mapBack(this.m_InstancesTemplates[m], i_m)) {
                int index;
                int n = index = this.kMap[m][i];
                y[n] = y[n] + 1.0;
            }
        }
        return y;
    }

    public int getK() {
        return this.m_K;
    }

    public void setK(int k) {
        this.m_K = k;
    }

    public int getM() {
        return this.m_M;
    }

    public void setM(int M2) {
        this.m_M = M2;
    }

    @Override
    public void setSeed(int s) {
        this.m_S = s;
    }

    @Override
    public int getSeed() {
        return this.m_S;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Grigorios Tsoumakas and Ioannis Katakis and Ioannis Vlahavas");
        result.setValue(TechnicalInformation.Field.TITLE, "Random k-Labelsets for Multi-Label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.VOLUME, "99");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Antti Puurula, Albert Bifet");
        additional.setValue(TechnicalInformation.Field.TITLE, "Multi-label Classification with Meta-labels");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "International Conference on Data Mining");
        additional.setValue(TechnicalInformation.Field.YEAR, "2014");
        result.add(additional);
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets M (default " + this.m_M + "): the number of subsets", "M", 1, "-M <num>"));
        newVector.addElement(new Option("\tSets k (default " + this.m_K + "): the size of partitions.", "k", 1, "-k <num>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        try {
            this.m_M = Integer.parseInt(Utils.getOption((char)'M', (String[])options));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_K = Integer.parseInt(Utils.getOption((char)'k', (String[])options));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-k");
        result.add("" + this.m_K);
        result.add("-M");
        result.add("" + this.m_M);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int k = 0; k < this.m_M; ++k) {
            s.append(Arrays.toString(this.kMap[k]));
        }
        return s.append("}").toString();
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RAkEL(), args);
    }
}

