/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.RAkEL;
import meka.core.MLUtils;
import meka.core.SuperLabelUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RAkELd
extends RAkEL {
    private static final long serialVersionUID = -6208388889440497990L;

    @Override
    public String globalInfo() {
        return "Takes RAndom partition of labELs; like RAkEL but labelsets are disjoint / non-overlapping subsets.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        int L = D.classIndex();
        int N = D.numInstances();
        Random r = new Random(this.m_S);
        int num = (int)Math.ceil(L / this.m_K);
        this.kMap = SuperLabelUtils.generatePartition(MLUtils.gen_indices(L), num, r, true);
        this.m_M = this.kMap.length;
        this.m_Classifiers = AbstractClassifier.makeCopies((Classifier)this.m_Classifier, (int)this.m_M);
        this.m_InstancesTemplates = new Instances[this.m_M];
        if (this.getDebug()) {
            System.out.println("Building " + this.m_M + " models of " + this.m_K + " partitions:");
        }
        for (int i = 0; i < this.m_M; ++i) {
            if (this.getDebug()) {
                System.out.println("\tpartitioning model " + (i + 1) + "/" + this.m_M + ": " + Arrays.toString(this.kMap[i]) + ", P=" + this.m_P + ", N=" + this.m_N);
            }
            Instances D_i = SuperLabelUtils.makePartitionDataset(D, this.kMap[i], this.m_P, this.m_N);
            if (this.getDebug()) {
                System.out.println("\tbuilding model " + (i + 1) + "/" + this.m_M + ": " + Arrays.toString(this.kMap[i]));
            }
            this.m_Classifiers[i].buildClassifier(D_i);
            this.m_InstancesTemplates[i] = new Instances(D_i, 0);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RAkELd(), args);
    }
}

