/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.MultilabelMetaClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.RevisionUtils;

public class BaggingML
extends MultilabelMetaClassifier {
    private static final long serialVersionUID = -6208337124420497991L;

    @Override
    public String globalInfo() {
        return "Combining several multi-label classifiers using Bootstrap AGGregatING";
    }

    public BaggingML() {
        this.m_BagSizePercent = 100;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.testCapabilities(train);
        if (this.getDebug()) {
            System.out.print("-: Models: ");
        }
        train = new Instances(train);
        this.m_Classifiers = MultilabelClassifier.makeCopies((MultilabelClassifier)this.m_Classifier, this.m_NumIterations);
        for (int i = 0; i < this.m_NumIterations; ++i) {
            int j;
            Random r = new Random(this.m_Seed + i);
            Instances bag = new Instances(train, 0);
            if (this.m_Classifiers[i] instanceof Randomizable) {
                ((Randomizable)this.m_Classifiers[i]).setSeed(this.m_Seed + i);
            }
            if (this.getDebug()) {
                System.out.print("" + i + " ");
            }
            int[] ixs = new int[train.numInstances()];
            for (j = 0; j < ixs.length; ++j) {
                int n = r.nextInt(ixs.length);
                ixs[n] = ixs[n] + 1;
            }
            for (j = 0; j < ixs.length; ++j) {
                if (ixs[j] <= 0) continue;
                Instance instance = train.instance(j);
                instance.setWeight((double)ixs[j]);
                bag.add(instance);
            }
            this.m_Classifiers[i].buildClassifier(bag);
        }
        if (this.getDebug()) {
            System.out.println(":-");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new BaggingML(), args);
    }
}

