/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.MultilabelMetaClassifier;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.RevisionUtils;

public class BaggingMLdup
extends MultilabelMetaClassifier {
    private static final long serialVersionUID = -5606278379913020097L;

    @Override
    public String globalInfo() {
        return "Combining several multi-label classifiers using Bootstrap AGGregatING.\nDuplicates Instances instead of assigning higher weights -- should work for methods that do not handle weights at all.";
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.testCapabilities(train);
        if (this.getDebug()) {
            System.out.print("-: Models: ");
        }
        this.m_Classifiers = MultilabelClassifier.makeCopies((MultilabelClassifier)this.m_Classifier, this.m_NumIterations);
        for (int i = 0; i < this.m_NumIterations; ++i) {
            Random r = new Random(this.m_Seed + i);
            Instances bag = new Instances(train, 0);
            if (this.m_Classifiers[i] instanceof Randomizable) {
                ((Randomizable)this.m_Classifiers[i]).setSeed(this.m_Seed + i);
            }
            if (this.getDebug()) {
                System.out.print("" + i + " ");
            }
            int bag_no = this.m_BagSizePercent * train.numInstances() / 100;
            while (bag.numInstances() < bag_no) {
                bag.add(train.instance(r.nextInt(train.numInstances())));
            }
            this.m_Classifiers[i].buildClassifier(bag);
        }
        if (this.getDebug()) {
            System.out.println(":-");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new BaggingMLdup(), args);
    }
}

