/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.MultilabelMetaClassifier;
import meka.core.A;
import meka.core.F;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RandomSubspaceML
extends MultilabelMetaClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 3608541911971484299L;
    protected int m_AttSizePercent = 50;
    protected int[][] m_Indices = null;
    protected Instances[] m_InstancesTemplates = null;

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        this.m_InstancesTemplates = new Instances[this.m_NumIterations];
        if (this.getDebug()) {
            System.out.print("-: Models: ");
        }
        this.m_Classifiers = MultilabelClassifier.makeCopies((MultilabelClassifier)this.m_Classifier, this.m_NumIterations);
        Random r = new Random(this.m_Seed);
        int N_sub = D.numInstances() * this.m_BagSizePercent / 100;
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        int d_new = d * this.m_AttSizePercent / 100;
        this.m_Indices = new int[this.m_NumIterations][];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            D.randomize(r);
            Instances D_cut = new Instances(D, 0, N_sub);
            D_cut.setClassIndex(-1);
            int[] indices_a = A.make_sequence(d);
            A.shuffle(indices_a, r);
            indices_a = Arrays.copyOfRange(indices_a, 0, d - d_new);
            Arrays.sort(indices_a);
            this.m_Indices[i] = indices_a;
            D_cut = F.remove(D_cut, indices_a, false);
            D_cut.setClassIndex(L);
            if (this.m_Classifiers[i] instanceof Randomizable) {
                ((Randomizable)this.m_Classifiers[i]).setSeed(this.m_Seed + i);
            }
            if (this.getDebug()) {
                System.out.print("" + i + " ");
            }
            this.m_Classifiers[i].buildClassifier(D_cut);
            this.m_InstancesTemplates[i] = new Instances(D_cut, 0);
        }
        if (this.getDebug()) {
            System.out.println(":-");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        double[] p = new double[x.classIndex()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            Instance x_ = (Instance)x.copy();
            x_.setDataset(null);
            for (int j = this.m_Indices[i].length - 1; j >= 0; --j) {
                x_.deleteAttributeAt(j);
            }
            x_.setDataset(this.m_InstancesTemplates[i]);
            double[] d = this.m_Classifiers[i].distributionForInstance(x_);
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                p[n] = p[n] + d[j];
            }
        }
        return p;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\t@Size of attribute space, as a percentage of total attribute space size (default " + this.m_AttSizePercent + ")", "A", 1, "-A <size percentage>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        try {
            this.m_AttSizePercent = Integer.parseInt(Utils.getOption((char)'A', (String[])options));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-A";
        options[current++] = String.valueOf(this.m_AttSizePercent);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RandomSubspaceML(), args);
    }

    @Override
    public String globalInfo() {
        return "Combining several multi-label classifiers in an ensemble where the attribute space for each model is a random subset of the original space.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public void setAttSizePercent(int value) {
        if (value > 0 && value <= 100) {
            this.m_AttSizePercent = value;
        } else {
            System.err.println("Bad percentage (must be between 1 and 100");
        }
    }

    public int getAttSizePercent() {
        return this.m_AttSizePercent;
    }

    public String attSizePercentTipText() {
        return "Size of attribute space, as a percentage of total attribute space size";
    }
}

