/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class SubsetMapper
extends MultilabelClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -6587406787943635084L;
    protected HashMap<String, Integer> m_Count = new HashMap();

    @Override
    public String globalInfo() {
        return "Maps the output of a multi-label classifier to a known label combination using the hamming distance.For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Robert E. Schapire, Yoram Singer ");
        result.setValue(TechnicalInformation.Field.TITLE, "Improved Boosting Algorithms Using Confidence-rated Predictions");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.VOLUME, "37");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "297-336");
        return result;
    }

    protected double[] nearestSubset(double[] d) throws Exception {
        String comb = MLUtils.toBitString(SubsetMapper.doubles2ints(d));
        if (this.m_Count.get(comb) != null) {
            return MLUtils.fromBitString(comb);
        }
        int closest_count = 0;
        int min_distance = Integer.MAX_VALUE;
        String nearest = comb;
        for (String current : this.shuffle(this.m_Count.keySet())) {
            int count;
            int distance = SubsetMapper.hammingDistance(current, comb);
            if (distance == min_distance && (count = this.m_Count.get(current).intValue()) > closest_count) {
                nearest = current;
                closest_count = count;
            }
            if (distance >= min_distance) continue;
            min_distance = distance;
            nearest = current;
            closest_count = this.m_Count.get(nearest);
        }
        return MLUtils.fromBitString(nearest);
    }

    private Collection<String> shuffle(Set<String> labelSubsets) {
        int seed = 1;
        Vector<String> result = new Vector<String>(labelSubsets.size());
        result.addAll(labelSubsets);
        Collections.shuffle(result, new Random(seed));
        return result;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        for (int i = 0; i < D.numInstances(); ++i) {
            this.m_Count.put(MLUtils.toBitString(D.instance(i), D.classIndex()), 0);
        }
        this.m_Classifier.buildClassifier(D);
    }

    @Override
    public double[] distributionForInstance(Instance TestInstance) throws Exception {
        double[] r = ((MultilabelClassifier)this.m_Classifier).distributionForInstance(TestInstance);
        return this.nearestSubset(r);
    }

    private static final int[] doubles2ints(double[] d) {
        int[] b = new int[d.length];
        for (int i = 0; i < d.length; ++i) {
            b[i] = (int)Math.round(d[i]);
        }
        return b;
    }

    private static final int hammingDistance(String s1, String s2) {
        int dist = 0;
        for (int i = 0; i < Math.min(s1.length(), s2.length()); ++i) {
            dist += Math.abs(MLUtils.char2int(s1.charAt(i)) - MLUtils.char2int(s2.charAt(i)));
        }
        return dist;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new SubsetMapper(), args);
    }
}

