/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multitarget;

import java.util.Arrays;
import java.util.Random;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multitarget.MultiTargetClassifier;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CCp
extends CC
implements MultiTargetClassifier {
    private static final long serialVersionUID = 7139310187485439658L;
    protected Link root = null;
    protected int m_S = 0;
    protected int[] m_Chain = null;
    protected double[] confidences = null;

    @Override
    public String globalInfo() {
        return "CC method with probabilistic output (CCp).\nThis version includes probabilistic output in the distributionForInstance, like other MT methods.\ni.e.: y[j+L] := P(y[j]|x) (this is usefull when used in an ensemble).";
    }

    @Override
    public void setSeed(int s) {
        this.m_S = s;
    }

    @Override
    public int getSeed() {
        return this.m_S;
    }

    @Override
    public void setChain(int[] chain) {
        this.m_Chain = chain;
    }

    @Override
    public int[] getChain() {
        return this.m_Chain;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int[] indices = this.getChain();
        if (indices == null) {
            indices = MLUtils.gen_indices(L);
            MLUtils.randomize(indices, new Random(this.m_S));
        }
        if (this.getDebug()) {
            System.out.print(":- Chain (");
        }
        this.root = new Link(indices, 0, D);
        if (this.getDebug()) {
            System.out.println(" ) -:");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        this.confidences = new double[L];
        this.root.classify(x);
        double[] y = new double[L * 2];
        for (int j = 0; j < L; ++j) {
            y[j] = x.value(j);
            y[j + L] = this.confidences[j];
        }
        return y;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CCp(), args);
    }

    protected class Link {
        private Link next = null;
        private AbstractClassifier classifier = null;
        public Instances _template = null;
        private int index = -1;
        private int[] excld;
        private int j = 0;

        public Link(int[] chain, int j, Instances train) throws Exception {
            this.j = j;
            this.index = chain[j];
            this.excld = Arrays.copyOfRange(chain, j + 1, chain.length);
            Arrays.sort(this.excld);
            this.classifier = (AbstractClassifier)AbstractClassifier.forName((String)CCp.this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)CCp.this.getClassifier()).getOptions());
            Instances new_train = new Instances(train);
            if (CCp.this.getDebug()) {
                System.out.print(" " + this.index);
            }
            new_train.setClassIndex(-1);
            int c_index = chain[j];
            for (int i = this.excld.length - 1; i >= 0; --i) {
                new_train.deleteAttributeAt(this.excld[i]);
                if (this.excld[i] >= this.index) continue;
                --c_index;
            }
            new_train.setClassIndex(c_index);
            this._template = new Instances(new_train, 0);
            this.classifier.buildClassifier(new_train);
            new_train = null;
            if (j + 1 < chain.length) {
                this.next = new Link(chain, ++j, train);
            }
        }

        protected void classify(Instance test) throws Exception {
            Instance copy = (Instance)test.copy();
            copy.setDataset(null);
            for (int i = this.excld.length - 1; i >= 0; --i) {
                copy.deleteAttributeAt(this.excld[i]);
            }
            copy.setDataset(this._template);
            for (int k = 0; k < this.j; ++k) {
                copy.setValue(this.j, (double)Math.round(copy.value(k)));
            }
            double[] dist = this.classifier.distributionForInstance(copy);
            int max_index = Utils.maxIndex((double[])dist);
            CCp.this.confidences[this.index] = dist[max_index];
            test.setValue(this.index, (double)max_index);
            if (this.next != null) {
                this.next.classify(test);
            }
        }

        public String toString() {
            return this.next == null ? String.valueOf(this.index) : String.valueOf(this.index) + ">" + this.next.toString();
        }
    }
}

