/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multitarget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.PS;
import meka.classifiers.multitarget.MultiTargetClassifier;
import meka.core.A;
import meka.core.MLUtils;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NSR
extends PS
implements MultiTargetClassifier {
    private static final long serialVersionUID = 8373228150066785001L;

    @Override
    public String globalInfo() {
        return "The Nearest Set Relpacement (NSR) method.\nA multi-target version of PS: The nearest sets are used to replace outliers, rather than subsets (as in PS).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setMinimumNumberInstances(1);
        return result;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        try {
            this.m_Classifier.buildClassifier(this.convertInstances(D, L));
        }
        catch (Exception e) {
            if (this.m_P > 0) {
                --this.m_P;
                System.err.println("Not enough distinct class values, trying again with P = " + this.m_P + " ...");
                this.buildClassifier(D);
            }
            throw new Exception("Failed to construct a classifier.");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int j;
        int L = x.classIndex();
        Instance x_sl = this.convertInstance(x, L);
        x_sl.setDataset(this.m_InstancesTemplate);
        double[] w = this.m_Classifier.distributionForInstance(x_sl);
        int max_j = Utils.maxIndex((double[])w);
        String y_max = this.m_InstancesTemplate.classAttribute().value(max_j);
        double[] y = Arrays.copyOf(A.toDoubleArray(MLUtils.decodeValue(y_max)), L * 2);
        HashMap[] votes = new HashMap[L];
        for (j = 0; j < L; ++j) {
            votes[j] = new HashMap();
        }
        for (int i = 0; i < w.length; ++i) {
            double[] y_i = A.toDoubleArray(MLUtils.decodeValue(this.m_InstancesTemplate.classAttribute().value(i)));
            for (int j2 = 0; j2 < y_i.length; ++j2) {
                votes[j2].put(y_i[j2], votes[j2].containsKey(y_i[j2]) ? (Double)votes[j2].get(y_i[j2]) + w[i] : w[i]);
            }
        }
        for (j = 0; j < L; ++j) {
            y[j + L] = votes[j].size() > 0 ? (Double)Collections.max(votes[j].values()) : 0.0;
        }
        return y;
    }

    public double[] convertDistribution(double[] y_sl, int L) {
        double[] y_ml = new double[L];
        for (int i = 0; i < y_sl.length; ++i) {
            if (!(y_sl[i] > 0.0)) continue;
            double[] d = MLUtils.fromBitString(this.m_InstancesTemplate.classAttribute().value(i));
            for (int j = 0; j < d.length; ++j) {
                if (!(d[j] > 0.0)) continue;
                y_ml[j] = 1.0;
            }
        }
        return y_ml;
    }

    public Instances convertInstances(Instances D, int L) throws Exception {
        HashMap<String, Integer> distinctCombinations = MLUtils.classCombinationCounts(D);
        if (this.getDebug()) {
            System.out.println("Found " + distinctCombinations.size() + " unique combinations");
        }
        MLUtils.pruneCountHashMap(distinctCombinations, this.m_P);
        if (this.getDebug()) {
            System.out.println("Pruned to " + distinctCombinations.size() + " with P=" + this.m_P);
        }
        Instances D_ = MLUtils.deleteAttributesAt(new Instances(D), MLUtils.gen_indices(L));
        D_.insertAttributeAt(new Attribute("CLASS", new ArrayList<String>(distinctCombinations.keySet())), 0);
        D_.setClassIndex(0);
        for (int i = 0; i < D.numInstances(); ++i) {
            String[] d_subsets;
            String y = MLUtils.encodeValue(MLUtils.toIntArray(D.instance(i), L));
            if (distinctCombinations.containsKey(y)) {
                D_.instance(i).setClassValue(y);
                continue;
            }
            if (this.m_N <= 0) continue;
            for (String s : d_subsets = NSR.getTopNSubsets(y, distinctCombinations, this.m_N)) {
                int w = distinctCombinations.get(s);
                Instance copy = (Instance)D_.instance(i).copy();
                copy.setClassValue(s);
                copy.setWeight(1.0 / (double)d_subsets.length);
                D_.add(copy);
            }
        }
        D_.deleteWithMissingClass();
        this.m_InstancesTemplate = new Instances(D_, 0);
        if (this.getDebug()) {
            System.out.println("" + D_);
        }
        return D_;
    }

    public static String[] decodeValue(String a) {
        return a.split("\\+");
    }

    public static String[] getTopNSubsets(String y, final HashMap<String, Integer> masterCombinations, int N) {
        String[] y_bits = y.split("\\+");
        ArrayList<String> Y = new ArrayList<String>();
        for (String y_ : masterCombinations.keySet()) {
            if (MLUtils.bitDifference(y_bits, y_.split("\\+")) > 1) continue;
            Y.add(y_);
        }
        Collections.sort(Y, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return (Integer)masterCombinations.get(s1) > (Integer)masterCombinations.get(s2) ? -1 : ((Integer)masterCombinations.get(s1) > (Integer)masterCombinations.get(s2) ? 1 : 0);
            }
        });
        String[] Y_strings = Y.toArray(new String[Y.size()]);
        return Arrays.copyOf(Y_strings, Math.min(N, Y_strings.length));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new NSR(), args);
    }
}

