/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import meka.core.A;
import meka.core.F;
import meka.core.LabelSet;
import meka.core.PSUtils;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public abstract class MLUtils {
    public static final String[] getDatasetOptions(Instances instances) {
        String name = instances.relationName();
        if (name.indexOf(58) > 0) {
            return name.substring(name.indexOf(58) + 1).split(" ");
        }
        return new String[0];
    }

    public static final String getDatasetName(Instances instances) {
        String name = instances.relationName();
        if (name.indexOf(58) > 0) {
            return name.substring(0, name.indexOf(58));
        }
        return name;
    }

    @Deprecated
    public static final int[] gen_indices(int L) {
        return A.make_sequence(L);
    }

    @Deprecated
    public static final void randomize(int[] array, Random r) {
        A.shuffle(array, r);
    }

    public static final double[] toDoubleArray(Instance x, int L) {
        double[] a = new double[L];
        for (int i = 0; i < L; ++i) {
            a[i] = Math.round(x.value(i));
        }
        return a;
    }

    public static final double[] toDoubleArray(Instance x) {
        int L = x.classIndex();
        return MLUtils.toDoubleArray(x, L);
    }

    public static final String toBitString(Instance x, int L) {
        StringBuilder sb = new StringBuilder(L);
        for (int i = 0; i < L; ++i) {
            sb.append((int)Math.round(x.value(i)));
        }
        return sb.toString();
    }

    public static final String toBitString(int[] i) {
        StringBuilder sb = new StringBuilder(i.length);
        for (int b : i) {
            sb.append(b);
        }
        return sb.toString();
    }

    public static final String toBitString(double[] d) {
        StringBuilder sb = new StringBuilder(d.length);
        for (double b : d) {
            sb.append((int)Math.round(b));
        }
        return sb.toString();
    }

    public static final double[] fromBitString(String s) {
        char[] a = s.toCharArray();
        double[] d = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = MLUtils.char2int(a[i]);
        }
        return d;
    }

    public static final int[] toIntArray(String s) {
        s = new String(s.trim());
        return MLUtils.toIntArray(s.substring(1, s.length() - 1).split(","));
    }

    public static final int[] toIntArray(String[] s) {
        int[] y = new int[s.length];
        for (int j = 0; j < s.length; ++j) {
            y[j] = Integer.parseInt(s[j].trim());
        }
        return y;
    }

    public static final List toSubIndicesSet(Instance x, int[] sub_indices) {
        ArrayList<Integer> y_list = new ArrayList<Integer>();
        for (int j : sub_indices) {
            if (!(x.value(j) > 0.0)) continue;
            y_list.add(j);
        }
        return y_list;
    }

    public static final List toIndicesSet(double[] x, double t) {
        ArrayList<Integer> y_list = new ArrayList<Integer>();
        for (int j = 0; j < x.length; ++j) {
            if (!(x[j] > t)) continue;
            y_list.add(j);
        }
        return y_list;
    }

    public static final List toIndicesSet(int[] x) {
        ArrayList<Integer> y_list = new ArrayList<Integer>();
        for (int j = 0; j < x.length; ++j) {
            if (x[j] <= 0) continue;
            y_list.add(j);
        }
        return y_list;
    }

    public static final List<Integer> toIndicesSet(Instance x, int L) {
        ArrayList<Integer> y_list = new ArrayList<Integer>();
        for (int j = 0; j < L; ++j) {
            if (!(x.value(j) > 0.0)) continue;
            y_list.add(j);
        }
        return y_list;
    }

    public static final int[] toSparseIntArray(Instance x, int L) {
        return A.toPrimitive(MLUtils.toIndicesSet(x, L));
    }

    public static final int[] fromSparseString(String s) {
        return MLUtils.toIntArray(s.split(","));
    }

    public static final int[] toIntArray(Instance x, int L) {
        int[] y = new int[L];
        for (int j = 0; j < L; ++j) {
            y[j] = (int)Math.round(x.value(j));
        }
        return y;
    }

    @Deprecated
    public static final int[] toIntArray(double[] z, double t) {
        return A.toIntArray(z, t);
    }

    public static final double[] toDoubleArray(String s) {
        s = new String(s.trim());
        return MLUtils.toDoubleArray(s.substring(1, s.length() - 1).split(","));
    }

    public static final double[] toDoubleArray(String[] s) {
        double[] y = new double[s.length];
        for (int j = 0; j < s.length; ++j) {
            y[j] = Double.parseDouble(s[j].trim());
        }
        return y;
    }

    public static final double labelCardinality(Instances D) {
        return MLUtils.labelCardinality(D, D.classIndex());
    }

    public static final double labelCardinality(Instances D, int L) {
        double sum = 0.0;
        for (int i = 0; i < D.numInstances(); ++i) {
            for (int j = 0; j < L; ++j) {
                sum += D.instance(i).value(j);
            }
        }
        return sum / (double)D.numInstances();
    }

    public static final double labelCardinality(int[][] Y, int j) {
        int N = Y.length;
        int L = Y[0].length;
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            sum += (double)Y[i][j];
        }
        return sum / (double)N;
    }

    public static final double labelCardinality(int[][] Y) {
        int N = Y.length;
        int L = Y[0].length;
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < L; ++j) {
                sum += (double)Y[i][j];
            }
        }
        return sum / (double)N;
    }

    public static final double[] labelCardinalities(Instances D) {
        int L = D.classIndex();
        double[] lc = new double[L];
        int j = 0;
        while (j < L) {
            for (int i = 0; i < D.numInstances(); ++i) {
                int n = j;
                lc[n] = lc[n] + D.instance(i).value(j);
            }
            int n = j++;
            lc[n] = lc[n] / (double)D.numInstances();
        }
        return lc;
    }

    public static final double[] labelCardinalities(ArrayList<int[]> Y) {
        int L = Y.get(0).length;
        double[] lc = new double[L];
        for (int[] y : Y) {
            for (int j = 0; j < L; ++j) {
                int n = j;
                lc[n] = lc[n] + (double)y[j];
            }
        }
        int j = 0;
        while (j < L) {
            int n = j++;
            lc[n] = lc[n] / (double)Y.size();
        }
        return lc;
    }

    public static final double emptyVectors(int[][] Y) {
        int N = Y.length;
        int L = Y[0].length;
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            if (!((double)Utils.sum((int[])Y[i]) <= 0.0)) continue;
            sum += 1.0;
        }
        return sum / (double)N;
    }

    public static final String mostCommonCombination(Instances D) {
        return MLUtils.mostCommonCombination(D, D.classIndex());
    }

    public static final String mostCommonCombination(Instances D, int L) {
        HashMap<String, Integer> hm = new HashMap<String, Integer>(D.numInstances());
        double max_v = 0.0;
        int max_i = 0;
        for (int i = 0; i < D.numInstances(); ++i) {
            String y = MLUtils.toBitString(D.instance(i), L);
            Integer v = (Integer)hm.get(y);
            if (v == null) {
                hm.put(y, 0);
                continue;
            }
            if ((double)v.intValue() > max_v) {
                max_v = v.intValue();
                max_i = i;
            }
            hm.put(y, v + 1);
        }
        return MLUtils.toBitString(D.instance(max_i), L);
    }

    public static final int bitDifference(String s1, String s2) {
        int sum = 0;
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++sum;
        }
        return sum;
    }

    public static final int bitDifference(String[] y1, String[] y2) {
        int sum = 0;
        for (int i = 0; i < y1.length; ++i) {
            if (y1[i].equals(y2[i])) continue;
            ++sum;
        }
        return sum;
    }

    public static final int bitDifference(int[] y1, int[] y2) {
        int sum = 0;
        for (int i = 0; i < y1.length; ++i) {
            if (y1[i] == y2[i]) continue;
            ++sum;
        }
        return sum;
    }

    public static final int bitCount(String s) {
        int total = 0;
        for (int i = 0; i < s.length(); ++i) {
            total += MLUtils.char2int(s.charAt(i));
        }
        return total;
    }

    public static final int char2int(char c) {
        return c - 48;
    }

    public static final HashMap<String, Integer> countCombinations(Instances D, int L) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            String y;
            Integer c = map.get(y = MLUtils.toBitString(D.instance(i), L));
            map.put(y, c == null ? 1 : c + 1);
        }
        return map;
    }

    public static final HashMap<LabelSet, Integer> countCombinationsSparse(Instances D, int L) {
        return PSUtils.countCombinationsSparse(D, L);
    }

    public static final HashMap<String, Integer> classCombinationCounts(Instances D) {
        int L = D.classIndex();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            String y;
            Integer c = map.get(y = MLUtils.encodeValue(MLUtils.toIntArray(D.instance(i), L)));
            map.put(y, c == null ? 1 : c + 1);
        }
        return map;
    }

    @Deprecated
    public static String encodeValue(int[] s) {
        StringBuilder sb = new StringBuilder(String.valueOf(s[0]));
        for (int i = 1; i < s.length; ++i) {
            sb.append('+').append(s[i]);
        }
        return sb.toString();
    }

    @Deprecated
    public static int[] decodeValue(String a) {
        return MLUtils.toIntArray(a.split("\\+"));
    }

    public static final Object maxItem(HashMap<?, Double> map) {
        Object max_k = null;
        double max_v = 0.0;
        for (Object k : map.keySet()) {
            if (!(map.get(k) >= max_v)) continue;
            max_k = k;
            max_v = map.get(k);
        }
        return max_k;
    }

    public static final Object argmax(HashMap<String, Integer> map) {
        String max_s = null;
        int max_v = 0;
        for (String s : map.keySet()) {
            Integer v = map.get(s);
            if (v <= max_v) continue;
            max_v = v;
            max_s = s;
        }
        return max_s;
    }

    public static final int numberOfUniqueCombinations(Instances D) {
        HashMap<String, Integer> hm = MLUtils.classCombinationCounts(D);
        return hm.size();
    }

    public static final Instance deleteAttributesAt(Instance x, int[] indicesToRemove) {
        Utils.sort((int[])indicesToRemove);
        for (int j = indicesToRemove.length - 1; j >= 0; --j) {
            x.deleteAttributeAt(indicesToRemove[j]);
        }
        return x;
    }

    public static final Instance keepAttributesAt(Instance x, int[] indicesToRemove, int lim) {
        return MLUtils.deleteAttributesAt(x, A.invert(indicesToRemove, lim));
    }

    public static final Instances deleteAttributesAt(Instances D, int[] indicesToRemove) {
        Utils.sort((int[])indicesToRemove);
        for (int j = indicesToRemove.length - 1; j >= 0; --j) {
            D.deleteAttributeAt(indicesToRemove[j]);
        }
        return D;
    }

    public static final Instances keepAttributesAt(Instances D, int[] indicesToRemove, int lim) {
        return MLUtils.deleteAttributesAt(D, A.invert(indicesToRemove, lim));
    }

    public static final Instance setTemplate(Instance x, Instances instancesTemplate) {
        int L = x.classIndex();
        int L_t = instancesTemplate.classIndex();
        x = (Instance)x.copy();
        x.setDataset(null);
        for (int i = L_t; i < L; ++i) {
            x.deleteAttributeAt(0);
        }
        x.setDataset(instancesTemplate);
        return x;
    }

    public static final Instance setTemplate(Instance x, Instance x_template, Instances D_template) {
        Instance x_ = (Instance)x_template.copy();
        int L_y = x.classIndex();
        int L_z = D_template.classIndex();
        MLUtils.copyValues(x_, x, L_y, L_z);
        MLUtils.setLabelsMissing(x_, L_z);
        x_.setDataset(D_template);
        return x_;
    }

    public static final Instance copyValues(Instance x_dest, Instance x_src, int from, int offset) {
        int d = x_src.numAttributes();
        int i = from;
        int j = 0;
        while (i < d) {
            x_dest.setValue(j + offset, x_src.value(i));
            ++i;
            ++j;
        }
        return x_dest;
    }

    public static final Instance copyValues(Instance x_dest, Instance x_src, int[] indices) {
        int i = 0;
        for (int j : indices) {
            x_dest.setValue(i++, x_src.value(j));
        }
        return x_dest;
    }

    public static final Instance setValues(Instance x, double[] z, int L) {
        for (int a = 0; a < z.length; ++a) {
            x.setValue(L + a, z[a]);
        }
        return x;
    }

    public static int mode(int[] a) {
        int max = 0;
        int count = 0;
        HashMap<Integer, Integer> d = new HashMap<Integer, Integer>();
        for (int v : a) {
            int n = d.containsKey(v) ? (Integer)d.get(v) + 1 : 1;
            d.put(v, n);
            if (n <= count) continue;
            max = v;
        }
        return max;
    }

    public static String printAsTextMatrix(double[][] M2) {
        StringBuilder sb = new StringBuilder("M = [\n");
        for (int j = 0; j < M2.length; ++j) {
            for (int k = 0; k < M2[j].length; ++k) {
                sb.append(Utils.doubleToString((double)M2[j][k], (int)8, (int)2));
            }
            if (j >= M2.length - 1) continue;
            sb.append("\n");
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static void pruneCountHashMap(HashMap<?, Integer> hm, int p) {
        ArrayList removeList = new ArrayList();
        for (Object obj : hm.keySet()) {
            if (hm.get(obj) > p) continue;
            removeList.add(obj);
        }
        for (Object obj : removeList) {
            hm.remove(obj);
        }
        removeList.clear();
        removeList = null;
    }

    public static HashMap<?, Integer> pruneCountHashMapBasedAsAFractionOf(HashMap<?, Integer> hm, double p, int N) {
        ArrayList al = new ArrayList();
        for (Object o : hm.keySet()) {
            if (!((double)hm.get(o).intValue() / (double)N <= p)) continue;
            al.add(o);
        }
        for (Object o : al) {
            hm.remove(o);
        }
        al.clear();
        al = null;
        return hm;
    }

    public static Instances setLabelsMissing(Instances D) {
        int L = D.classIndex();
        for (int i = 0; i < D.numInstances(); ++i) {
            for (int j = 0; j < L; ++j) {
                D.instance(i).setMissing(j);
            }
        }
        return D;
    }

    public static Instance setLabelsMissing(Instance x) {
        return MLUtils.setLabelsMissing(x, x.classIndex());
    }

    public static Instance setLabelsMissing(Instance x, int L) {
        for (int j = 0; j < L; ++j) {
            x.setMissing(j);
        }
        return x;
    }

    public static final Instances combineInstances(Instances D1, Instances D2) {
        Instances D = new Instances(D1);
        for (int i = 0; i < D2.numInstances(); ++i) {
            D.add(D2.instance(i));
        }
        return D;
    }

    public static final String toDebugString(Instances D) {
        int L = D.classIndex();
        StringBuilder sb = new StringBuilder();
        sb.append("D=" + D.numInstances());
        sb.append(" L=" + L + " {");
        for (int j = 0; j < L; ++j) {
            sb.append(D.attribute(j).name() + " ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static final String toDebugString(Instance x) {
        int j;
        int L = x.classIndex();
        StringBuilder sb = new StringBuilder();
        sb.append("y = [");
        for (j = 0; j < L; ++j) {
            sb.append(x.value(j) + " ");
        }
        sb.append("], x = [");
        for (j = L; j < L + 10; ++j) {
            sb.append(x.value(j) + " ");
        }
        sb.append(" ... ]");
        return sb.toString();
    }

    public static int[] toPrimitive(Integer[] a) {
        int[] b = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static final String toBinaryString(int l, int L) {
        String sb = new String(Integer.toBinaryString(l));
        while (sb.length() < L) {
            sb = "0" + sb;
        }
        return sb;
    }

    private static void permute(String beginningString, String endingString, ArrayList<String> perm) {
        if (endingString.length() <= 1) {
            perm.add(beginningString + endingString);
        } else {
            for (int i = 0; i < endingString.length(); ++i) {
                String newString = endingString.substring(0, i) + endingString.substring(i + 1);
                MLUtils.permute(beginningString + endingString.charAt(i), newString, perm);
            }
        }
    }

    public static String[] permute(String s) {
        ArrayList<String> a = new ArrayList<String>();
        MLUtils.permute("", s, a);
        return a.toArray(new String[0]);
    }

    public static String hashMapToString(HashMap<?, ?> map, int dp) {
        StringBuilder sb = new StringBuilder();
        for (Object k : map.keySet()) {
            sb.append(Utils.padRight((String)k.toString(), (int)20));
            sb.append(" : ");
            if (dp < 0) {
                sb.append(map.get(k));
            } else {
                sb.append(Utils.doubleToString((double)((Double)map.get(k)), (int)5, (int)dp));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String hashMapToString(HashMap<?, ?> map) {
        return MLUtils.hashMapToString(map, -1);
    }

    public static int getIntegerOption(String op, int def) {
        try {
            return Integer.parseInt(op);
        }
        catch (Exception e) {
            System.err.println("[Warning] Failed to parse " + op + " to integer number; using default of " + def);
            return def;
        }
    }

    public static void clearLabels(Instance x) {
        int L = x.classIndex();
        for (int j = 0; j < L; ++j) {
            x.setValue(j, 0.0);
        }
    }

    public static double[][] getXfromD(Instances D) {
        int N = D.numInstances();
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        double[][] X = new double[N][d];
        for (int i = 0; i < N; ++i) {
            for (int k = 0; k < d; ++k) {
                X[i][k] = D.instance(i).value(k + L);
            }
        }
        return X;
    }

    public static double[][] getYfromD(Instances D) {
        int L = D.classIndex();
        int N = D.numInstances();
        double[][] Y = new double[N][L];
        for (int i = 0; i < N; ++i) {
            for (int k = 0; k < L; ++k) {
                Y[i][k] = D.instance(i).value(k);
            }
        }
        return Y;
    }

    public static double[] getxfromInstance(Instance xy) {
        int L = xy.classIndex();
        double[] xy_ = xy.toDoubleArray();
        return Arrays.copyOfRange(xy_, L, xy_.length);
    }

    public static Instances replaceZasAttributes(Instances D, double[][] Z, int L) {
        D.setClassIndex(0);
        int m = D.numAttributes() - L;
        for (int j = 0; j < m; ++j) {
            D.deleteAttributeAt(L);
        }
        return MLUtils.addZtoD(D, Z, L);
    }

    public static Instances replaceZasClasses(Instances D, double[][] Z, int L) {
        D.setClassIndex(-1);
        for (int j = 0; j < L; ++j) {
            D.deleteAttributeAt(0);
        }
        return MLUtils.insertZintoD(D, Z);
    }

    private static Instances insertZintoD(Instances D, double[][] Z) {
        int j;
        int L = Z[0].length;
        for (j = 0; j < L; ++j) {
            D.insertAttributeAt(new Attribute("c" + j, Arrays.asList("0", "1")), j);
        }
        for (j = 0; j < L; ++j) {
            for (int i = 0; i < D.numInstances(); ++i) {
                D.instance(i).setValue(j, Z[i][j] > 0.5 ? 1.0 : 0.0);
            }
        }
        D.setClassIndex(L);
        return D;
    }

    private static Instances addZtoD(Instances D, double[][] Z, int L) {
        int a;
        int H = Z[0].length;
        int N = D.numInstances();
        for (a = 0; a < H; ++a) {
            D.insertAttributeAt(new Attribute("A" + a), L + a);
        }
        for (a = 0; a < H; ++a) {
            for (int i = 0; i < N; ++i) {
                D.instance(i).setValue(L + a, Z[i][a]);
            }
        }
        D.setClassIndex(L);
        return D;
    }

    public int[] getK(Instances D) {
        int L = D.classIndex();
        HashSet[] counts = new HashSet[L];
        int[] K = new int[L];
        for (int j = 0; j < L; ++j) {
            counts[j] = new HashSet();
            for (Instance x : D) {
                int k = (int)x.value(j);
                counts[j].add(k);
            }
            K[j] = counts[j].size();
        }
        return K;
    }

    public static final Object loadObject(String filename) throws Exception {
        FileInputStream streamIn = new FileInputStream(filename);
        ObjectInputStream objectinputstream = new ObjectInputStream(streamIn);
        Object object = objectinputstream.readObject();
        objectinputstream.close();
        return object;
    }

    public static final void saveObject(Object object, String filename) throws Exception {
        FileOutputStream fout = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(object);
        oos.flush();
        oos.close();
    }

    public static void prepareData(Instances data) throws Exception {
        String[] doptions = null;
        try {
            doptions = MLUtils.getDatasetOptions(data);
        }
        catch (Exception e) {
            throw new Exception("[Error] Failed to Get Options from @Relation Name", e);
        }
        try {
            int c;
            int n = c = Utils.getOptionPos((char)'C', (String[])doptions) >= 0 ? Integer.parseInt(Utils.getOption((char)'C', (String[])doptions)) : Integer.parseInt(Utils.getOption((char)'c', (String[])doptions));
            if (c < 0) {
                c = -c;
                data = F.mulan2meka(data, c);
            }
            data.setClassIndex(c);
        }
        catch (Exception e) {
            throw new Exception("Failed to parse options stored in relation name; expected format for relation name:\n  'name: options'\nBut found:\n  '" + data.relationName() + "'\n" + "Format example:\n" + "  'Example_Dataset: -C 3 -split-percentage 50'\n" + "'-C 3' specifies the number of target attributes to be 3. See tutorial for more information.", e);
        }
    }

    public static int peekClassIndex(File file) {
        int result = Integer.MAX_VALUE;
        try {
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(file.getAbsolutePath());
            Instances structure = source.getStructure();
            MLUtils.prepareData(structure);
            result = structure.classIndex();
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static final void main(String[] args) throws Exception {
        if (args.length > 0) {
            Instances D = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            int N = D.numInstances();
            int L = Integer.parseInt(Utils.getOption((char)'C', (String[])MLUtils.getDatasetOptions(D)));
            D.setClassIndex(L);
            switch (args[1].charAt(0)) {
                case 'L': {
                    System.out.println(L);
                    break;
                }
                case 'N': {
                    System.out.println(D.numInstances());
                    break;
                }
                case 'd': {
                    System.out.println(D.numAttributes() - L);
                    break;
                }
                case 'A': {
                    System.out.println(D.numAttributes());
                    break;
                }
                case 'l': {
                    System.out.println(MLUtils.labelCardinality(D));
                    break;
                }
                case 'P': {
                    System.out.println(Arrays.toString(MLUtils.labelCardinalities(D)));
                    break;
                }
                case 'C': {
                    System.out.println(MLUtils.hashMapToString(MLUtils.countCombinations(D, L)));
                    break;
                }
                case 'p': {
                    System.out.println("collecting ...");
                    HashMap<LabelSet, Integer> hm = PSUtils.countCombinationsSparse(D, L);
                    System.out.println("pruning ...");
                    System.out.println("writing ...");
                    MLUtils.saveObject(hm, "hm-NEW.serialized");
                    break;
                }
                default: {
                    System.out.println(MLUtils.getDatasetName(D));
                }
            }
            return;
        }
    }
}

