/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import meka.core.F;
import meka.core.LabelSet;
import meka.core.LabelSetComparator;
import meka.core.MLUtils;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public abstract class PSUtils {
    public static int sumCounts(HashMap<LabelSet, Integer> map) {
        int c = 0;
        for (Integer c_ : map.values()) {
            c += c_.intValue();
        }
        return c;
    }

    public static int countSubsets(LabelSet ysub, Set<LabelSet> Y) {
        int c = 0;
        for (LabelSet s : Y) {
            if (ysub.subsetof(s) <= 0) continue;
            ++c;
        }
        return c;
    }

    public static Set<LabelSet> getSubsets(LabelSet y, Set<LabelSet> set) {
        HashSet<LabelSet> subsets = new HashSet<LabelSet>();
        for (LabelSet s : set) {
            int m = LabelSet.subset(s.indices, y.indices);
            if (m <= 0) continue;
            subsets.add(s);
        }
        return subsets;
    }

    public static SortedSet<LabelSet> getSortedSubsets(LabelSet y, Set<LabelSet> set, Comparator cmp) {
        TreeSet<LabelSet> subsets = new TreeSet<LabelSet>(cmp);
        for (LabelSet s : set) {
            int m = LabelSet.subset(s.indices, y.indices);
            if (m <= 0) continue;
            subsets.add(s);
        }
        return subsets;
    }

    public static SortedSet<LabelSet> getSortedSubsets(LabelSet y, HashMap<LabelSet, Integer> map) {
        return PSUtils.getSortedSubsets(y, map.keySet(), new LabelSetComparator(map));
    }

    public static LabelSet[] cover(LabelSet y, HashMap<LabelSet, Integer> map) {
        Integer count = map.get(y);
        if (count != null && count >= 1) {
            return new LabelSet[]{y};
        }
        LabelSetComparator cmp = new LabelSetComparator(map);
        SortedSet<LabelSet> allS = PSUtils.getSortedSubsets(y, map.keySet(), cmp);
        Set<LabelSet> covS = PSUtils.cover(y, allS, cmp);
        return covS.toArray(new LabelSet[0]);
    }

    public static Set<LabelSet> cover(LabelSet y, SortedSet<LabelSet> S, Comparator cmp) {
        LabelSet y_copy = y.deep_copy();
        HashSet<LabelSet> K = new HashSet<LabelSet>();
        while (S.size() > 0 && y_copy.indices.length > 0) {
            LabelSet s_ = S.last();
            K.add(s_);
            y_copy.minus(s_);
            S = PSUtils.getSortedSubsets(y_copy, S, cmp);
        }
        return K;
    }

    public static LabelSet[] getAllSubsets(LabelSet y, HashMap<LabelSet, Integer> map) {
        Integer count = map.get(y);
        if (count != null && count >= 1) {
            return new LabelSet[]{y};
        }
        SortedSet<LabelSet> subsets = PSUtils.getSortedSubsets(y, map.keySet(), new LabelSetComparator(map));
        LabelSet[] s = subsets.toArray(new LabelSet[subsets.size()]);
        return s;
    }

    public static LabelSet[] getTopNSubsets(LabelSet y, HashMap<LabelSet, Integer> map, int n) {
        LabelSet[] s = PSUtils.getAllSubsets(y, map);
        return Arrays.copyOfRange(s, Math.max(0, s.length - n), s.length);
    }

    public static SortedSet<LabelSet> getTopNSubsetsAsSet(LabelSet y, HashMap<LabelSet, Integer> map, int n) {
        SortedSet<LabelSet> allSets = PSUtils.getSortedSubsets(y, map);
        TreeSet<LabelSet> topSets = new TreeSet<LabelSet>();
        int n_ = 0;
        for (LabelSet Y : allSets) {
            topSets.add(Y);
            if (++n_ <= n) continue;
            break;
        }
        return topSets;
    }

    public static LabelSet getTopSubset(LabelSet y, HashMap<LabelSet, Integer> map) {
        return PSUtils.getTopNSubsets(y, map, 1)[0];
    }

    public static HashMap<LabelSet, Integer> countCombinationsSparseSubset(Instances D, int[] indices) {
        HashMap<LabelSet, Integer> map = new HashMap<LabelSet, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet m;
            map.put(m, map.containsKey(m = new LabelSet(MLUtils.toSubIndicesSet(D.instance(i), indices))) ? map.get(m) + 1 : 1);
        }
        return map;
    }

    public static final HashMap<LabelSet, Integer> countCombinationsSparse(Instances D, int L) {
        HashMap<LabelSet, Integer> map = new HashMap<LabelSet, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet y;
            Integer c = map.get(y = new LabelSet(MLUtils.toSparseIntArray(D.instance(i), L)));
            map.put(y, c == null ? 1 : c + 1);
        }
        return map;
    }

    @Deprecated
    private static final double[] toDoubleArray(String labelSet, int L) {
        int[] set = labelSet.length() <= 2 ? new int[]{} : MLUtils.toIntArray(labelSet);
        double[] y = new double[L];
        for (int j : set) {
            y[j] = 1.0;
        }
        return y;
    }

    @Deprecated
    public static double[] convertDistribution(double[] p, int L, Instances iTemplate) {
        double[] y = new double[L];
        int i = Utils.maxIndex((double[])p);
        double[] d = PSUtils.toDoubleArray(iTemplate.classAttribute().value(i), L);
        for (int j = 0; j < d.length; ++j) {
            if (!(d[j] > 0.0)) continue;
            y[j] = 1.0;
        }
        return y;
    }

    public static double[] convertDistribution(double[] p, int L, LabelSet[] meta_labels) {
        double[] y = new double[L];
        for (int i = 0; i < p.length; ++i) {
            LabelSet Y_i = meta_labels[i];
            int[] arr$ = Y_i.indices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int j;
                int n = j = arr$[i$];
                y[n] = y[n] + p[i];
            }
        }
        return y;
    }

    public static final LabelSet[] makeLabelSetMap(Instances T) {
        int L_ = 4;
        return new LabelSet[L_];
    }

    public static final double[] recombination(double[] p, int L, LabelSet[] map) {
        double[] y = new double[L];
        int i = Utils.maxIndex((double[])p);
        LabelSet y_meta = map[i];
        for (int j : y_meta.indices) {
            y[j] = 1.0;
        }
        return y;
    }

    public static final double[] recombination_t(double[] p, int L, Instances iTemplate) {
        double[] y = new double[L];
        for (int i = 0; i < p.length; ++i) {
            double[] d = MLUtils.fromBitString(iTemplate.classAttribute().value(i));
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                y[n] = y[n] + d[j] * p[i];
            }
        }
        return y;
    }

    public static final double[] recombination_t(double[] p, int L, LabelSet[] map) {
        double[] y = new double[L];
        for (int i = 0; i < p.length; ++i) {
            LabelSet y_meta = map[i];
            int[] arr$ = y_meta.indices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int j;
                int n = j = arr$[i$];
                y[n] = y[n] + p[i];
            }
        }
        return y;
    }

    public static Instance convertInstance(Instance x, int L, Instances template) {
        Instance x_ = (Instance)x.copy();
        x_.setDataset(null);
        for (int i = 0; i < L; ++i) {
            x_.deleteAttributeAt(0);
        }
        x_.insertAttributeAt(0);
        x_.setDataset(template);
        return x_;
    }

    public static Instances LCTransformation(Instances D) {
        return PSUtils.LCTransformation(D, D.classIndex());
    }

    public static Instances LCTransformation(Instances D, int L) {
        return PSUtils.PSTransformation(D, L, 0, 0);
    }

    public static Instances PSTransformation(Instances D, int P, int N) {
        return PSUtils.PSTransformation(D, D.classIndex(), P, N);
    }

    public static Instances PSTransformation(Instances D, int L, int p, int n) {
        D = new Instances(D);
        HashMap<LabelSet, Integer> distinctCombinations = PSUtils.countCombinationsSparse(D, L);
        if (p > 0) {
            MLUtils.pruneCountHashMap(distinctCombinations, p);
        }
        if (distinctCombinations.size() <= 1 && p > 0) {
            System.err.println("[Warning] You did too much pruning, setting P = P-1");
            return PSUtils.PSTransformation(D, L, p - 1, n);
        }
        ArrayList<String> ClassValues = new ArrayList<String>();
        for (LabelSet y : distinctCombinations.keySet()) {
            ClassValues.add(y.toString());
        }
        Attribute C = new Attribute("Class", ClassValues);
        D.insertAttributeAt(C, L);
        D.setClassIndex(L);
        int N = D.numInstances();
        for (int i = 0; i < N; ++i) {
            Instance x = D.instance(i);
            LabelSet y = new LabelSet(MLUtils.toSparseIntArray(x, L));
            String y_string = y.toString();
            if (ClassValues.contains(y_string)) {
                x.setClassValue(y_string);
                continue;
            }
            if (n <= 0) continue;
            LabelSet[] d_subsets = PSUtils.getTopNSubsets(y, distinctCombinations, n);
            if (d_subsets.length > 0) {
                x.setClassValue(d_subsets[0].toString());
                if (d_subsets.length <= 1) continue;
                for (int s_i = 1; s_i < d_subsets.length; ++s_i) {
                    Instance x_ = (Instance)x.copy();
                    x_.setClassValue(d_subsets[s_i].toString());
                    D.add(x_);
                }
                continue;
            }
            x.setClassMissing();
        }
        D.deleteWithMissingClass();
        try {
            D = F.removeLabels(D, L);
        }
        catch (Exception e) {
            // empty catch block
        }
        D.setClassIndex(0);
        return D;
    }

    @Deprecated
    public static Instances PSTransformationOLD(Instances D, int L, int P, int N) {
        System.out.println("counting");
        HashMap<LabelSet, Integer> distinctCombinations = PSUtils.countCombinationsSparse(D, L);
        System.out.println("pruning");
        if (P > 0) {
            MLUtils.pruneCountHashMap(distinctCombinations, P);
        }
        if (distinctCombinations.size() <= 1 && P > 0) {
            System.err.println("[Warning] You did too much pruning, setting P = P-1");
            return PSUtils.PSTransformation(D, L, P - 1, N);
        }
        System.out.println("transforming");
        ArrayList<String> ClassValues = new ArrayList<String>();
        for (LabelSet y : distinctCombinations.keySet()) {
            ClassValues.add(y.toString());
        }
        Attribute C = new Attribute("Class", ClassValues);
        System.out.println("remove attributes");
        Instances D_ = null;
        try {
            D_ = F.removeLabels(D, L);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("add attributes");
        D_.insertAttributeAt(C, 0);
        D_.setClassIndex(0);
        System.out.println("reintroing");
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet[] d_subsets;
            Instance x = D.instance(i);
            LabelSet y = new LabelSet(MLUtils.toSparseIntArray(x, L));
            System.out.println("===" + i + " " + y);
            String y_string = y.toString();
            if (ClassValues.contains(y_string)) {
                D_.instance(i).setClassValue(y_string);
                continue;
            }
            if (N <= 0) continue;
            for (LabelSet s : d_subsets = PSUtils.getTopNSubsets(y, distinctCombinations, N)) {
                System.out.println("" + s);
                Instance x_ = (Instance)D_.instance(i).copy();
                x_.setClassValue(s.toString());
                D_.add(x_);
            }
        }
        D_.deleteWithMissingClass();
        return D_;
    }

    public static Instance[] PSTransformation(Instance x, int L, HashMap<LabelSet, Integer> map, int n) {
        LabelSet y = new LabelSet(MLUtils.toSparseIntArray(x, L));
        if (map.get(y) != null) {
            Instance[] x_subsets = new Instance[]{PSUtils.convertInstance(x, L, x.dataset())};
            x_subsets[0].setClassValue(y.toString());
            return x_subsets;
        }
        LabelSet[] d_subsets = PSUtils.getTopNSubsets(y, map, n);
        Instance[] x_subsets = new Instance[d_subsets.length];
        Instance x_template = PSUtils.convertInstance(x, L, x.dataset());
        for (int i = 1; i < d_subsets.length; ++i) {
            x_subsets[i] = (Instance)x_template.copy();
            x_subsets[i].setClassValue(d_subsets[i].toString());
        }
        return x_subsets;
    }

    public static final LabelSet[] convert(LabelSet[] sparseY, HashMap<LabelSet, Integer> map) {
        return null;
    }

    public static final void saveMap(String filename, HashMap<LabelSet, Integer> map) throws Exception {
        MLUtils.saveObject(map, filename);
    }

    public static HashMap<LabelSet, Integer> loadMap(String filename) throws Exception {
        return (HashMap)MLUtils.loadObject(filename);
    }
}

