/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import meka.core.A;
import meka.core.LabelSet;
import meka.core.MLEvalUtils;
import meka.core.MLUtils;
import meka.core.ThresholdUtils;
import weka.core.Instance;
import weka.core.Utils;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int L = 0;
    public ArrayList<double[]> predictions = null;
    public ArrayList<int[]> actuals = null;
    public HashMap<String, Double> output = new LinkedHashMap<String, Double>();
    public HashMap<String, String> info = new LinkedHashMap<String, String>();
    public HashMap<String, Double> vals = new LinkedHashMap<String, Double>();

    public Result() {
        this.predictions = new ArrayList();
        this.actuals = new ArrayList();
    }

    public Result(int L) {
        this.predictions = new ArrayList();
        this.actuals = new ArrayList();
        this.L = L;
    }

    public Result(int N, int L) {
        this.predictions = new ArrayList(N);
        this.actuals = new ArrayList(N);
        this.L = L;
    }

    public int size() {
        return this.predictions.size();
    }

    public String toString() {
        int V;
        String resultString = "";
        if (this.info.containsKey("Verbosity") && (V = MLUtils.getIntegerOption(this.info.get("Verbosity"), 1)) > 4) {
            resultString = Result.getResultAsString(this, V - 5);
        }
        return resultString + MLUtils.hashMapToString(this.info) + "\n" + MLUtils.hashMapToString(this.output, 3) + "\n" + MLUtils.hashMapToString(this.vals, 3);
    }

    public void addResult(double[] pred, Instance real) {
        this.predictions.add(pred);
        this.actuals.add(MLUtils.toIntArray(real, pred.length));
    }

    public int[] rowActual(int i) {
        return this.actuals.get(i);
    }

    public double[] rowRanking(int i) {
        return this.predictions.get(i);
    }

    public int[] rowPrediction(int i, double t) {
        return MLUtils.toIntArray(this.rowRanking(i), t);
    }

    public int[] rowPrediction(int i) {
        return ThresholdUtils.threshold(this.rowRanking(i), this.info.get("Threshold"));
    }

    public double[][] allPredictions() {
        double[][] Y = new double[this.predictions.size()][];
        for (int i = 0; i < this.predictions.size(); ++i) {
            Y[i] = this.rowRanking(i);
        }
        return Y;
    }

    public int[][] allPredictions(double t) {
        int[][] Y = new int[this.predictions.size()][];
        for (int i = 0; i < this.predictions.size(); ++i) {
            Y[i] = this.rowPrediction(i, t);
        }
        return Y;
    }

    public int[][] allActuals() {
        int[][] Y = new int[this.actuals.size()][];
        for (int i = 0; i < this.actuals.size(); ++i) {
            Y[i] = this.rowActual(i);
        }
        return Y;
    }

    public void addValue(String metric, double v) {
        Double freq = this.vals.get(metric);
        this.vals.put(metric, freq == null ? v : freq + v);
    }

    public void setValue(String metric, double v) {
        this.vals.put(metric, v);
    }

    public double getValue(String metric) {
        return this.vals.get(metric);
    }

    public void setInfo(String cat, String val) {
        this.info.put(cat, val);
    }

    public String getInfo(String cat) {
        return this.info.get(cat);
    }

    public static HashMap<String, Double> getStats(Result r, String vop) {
        if (r.getInfo("Type").equalsIgnoreCase("MT")) {
            return MLEvalUtils.getMTStats(r.allPredictions(), r.allActuals(), vop);
        }
        return MLEvalUtils.getMLStats(r.allPredictions(), r.allActuals(), r.getInfo("Threshold"), vop);
    }

    public static String getResultAsString(Result s) {
        return Result.getResultAsString(s, 3);
    }

    public static String getResultAsString(Result s, int adp) {
        StringBuilder sb = new StringBuilder();
        double N = s.predictions.size();
        sb.append("|==== PREDICTIONS ===============>\n");
        int i = 0;
        while ((double)i < N) {
            sb.append("|");
            sb.append(Utils.doubleToString((double)(i + 1), (int)5, (int)0));
            sb.append(" ");
            if (adp == 0) {
                LabelSet y = new LabelSet(MLUtils.toIndicesSet(s.actuals.get(i)));
                sb.append(y).append(" ");
                LabelSet ypred = new LabelSet(MLUtils.toIndicesSet(s.rowPrediction(i)));
                sb.append(ypred).append("\n");
            } else {
                sb.append(A.toString(s.actuals.get(i)));
                sb.append(" ");
                sb.append(A.toString(s.predictions.get(i), adp));
                sb.append("\n");
            }
            ++i;
        }
        sb.append("|==============================<\n");
        return sb.toString();
    }

    public static void writeResultToFile(Result result, String fname) throws Exception {
        PrintWriter outer = new PrintWriter(new BufferedWriter(new FileWriter(fname)));
        StringBuilder sb = new StringBuilder();
        sb.append("L=").append(result.L).append('\n');
        for (String k : result.info.keySet()) {
            sb.append("i:").append(k).append('=').append(result.info.get(k)).append('\n');
        }
        for (String k : result.vals.keySet()) {
            sb.append("v:").append(k).append('=').append(result.vals.get(k)).append('\n');
        }
        sb.append(Result.getResultAsString(result));
        outer.write(sb.toString());
        outer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result readResultFromFile(String fname) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(fname));
        Result r = null;
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                int idx;
                if (line.contains("[") && !line.contains(":")) {
                    int i1s = line.indexOf("[");
                    int i1e = line.indexOf("]");
                    int i2s = line.indexOf("[", i1s + 1);
                    int i2e = line.indexOf("]", i1e + 1);
                    r.predictions.add(MLUtils.toDoubleArray(line.substring(i2s + 1, i2e).trim().split(" ")));
                    r.actuals.add(MLUtils.toIntArray(line.substring(i1s + 1, i1e).trim().split(" ")));
                    continue;
                }
                if (line.startsWith("i")) {
                    line = line.substring(line.indexOf(58) + 1);
                    idx = line.indexOf(61);
                    r.info.put(line.substring(0, idx), line.substring(idx + 1));
                    continue;
                }
                if (line.startsWith("v")) {
                    line = line.substring(line.indexOf(58) + 1);
                    idx = line.indexOf(61);
                    r.vals.put(line.substring(0, idx), Double.parseDouble(line.substring(idx + 1)));
                    continue;
                }
                if (!line.startsWith("L")) continue;
                r = new Result(Integer.parseInt(line.substring(line.indexOf(61) + 1)));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return r;
    }

    public static void main(String[] args) {
        String voption = "1";
        try {
            if (Utils.getOptionPos((String)"verbosity", (String[])args) >= 0) {
                voption = Utils.getOption((String)"verbosity", (String[])args);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Utils.getOptionPos((char)'f', (String[])args) >= 0 && Utils.getOptionPos((char)'x', (String[])args) >= 0) {
            int numFolds = 0;
            try {
                numFolds = Integer.parseInt(Utils.getOption((char)'x', (String[])args));
            }
            catch (Exception e) {
                System.err.println("Failed to parse the number of folds");
                e.printStackTrace();
                System.exit(1);
            }
            Result[] fold = new Result[numFolds];
            String basename = null;
            try {
                basename = Utils.getOption((char)'f', (String[])args);
                for (int i = 0; i < numFolds; ++i) {
                    fold[i] = Result.readResultFromFile(basename + "." + i);
                    fold[i].output = Result.getStats(fold[i], voption);
                    if (fold[i].getInfo("Threshold") != null) continue;
                    System.out.println("Having to calculate a threshold ...");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.err.println("Error finding/loading files ... Was looking for " + basename + ".0 ... " + basename + "." + numFolds);
                e.printStackTrace();
                System.exit(1);
            }
            Result r = MLEvalUtils.averageResults(fold);
            System.out.println(r.toString());
        } else if (Utils.getOptionPos((char)'f', (String[])args) >= 0) {
            Result r = null;
            try {
                r = Result.readResultFromFile(Utils.getOption((char)'f', (String[])args));
                if (Utils.getOptionPos((String)"threshold", (String[])args) >= 0) {
                    r.setInfo("Threshold", Utils.getOption((String)"threshold", (String[])args));
                    System.out.println("Setting threshold from command line: " + r.getInfo("Threshold"));
                } else if (r.getInfo("Threshold") != null) {
                    String t = r.getInfo("Threshold");
                    System.out.println("using threshold " + t);
                } else {
                    String t = Arrays.toString(ThresholdUtils.calibrateThresholds(r.predictions, MLUtils.labelCardinalities(r.actuals)));
                    System.out.println("Did not find threshold, calibrated a new one: " + t);
                    r.setInfo("Threshold", t);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            r.setInfo("Verbosity", voption);
            r.output = Result.getStats(r, voption);
            System.out.println(r.toString());
        } else {
            System.out.println("You must supply the filename with -f <filename> (and -x <num folds> if dealing with CV).");
        }
    }
}

