/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import meka.core.A;
import meka.core.F;
import meka.core.LabelSet;
import meka.core.MLUtils;
import meka.core.PSUtils;
import weka.core.Instances;

public abstract class SuperLabelUtils {
    public static int[] get_k_subset(int L, int k, Random r) {
        int[] indices = A.make_sequence(L);
        A.shuffle(indices, r);
        int[] part = Arrays.copyOf(indices, k);
        Arrays.sort(part);
        return part;
    }

    private static int[][] generatePartition(int num, double[][] M2, Random r) {
        int i;
        int L = M2.length;
        int[] indices = A.make_sequence(L);
        MLUtils.randomize(indices, r);
        ArrayList[] Y_meta = new ArrayList[num];
        for (i = 0; i < num; ++i) {
            Y_meta[i] = new ArrayList();
            Y_meta[i].add(indices[i]);
        }
        for (i = num; i < L; ++i) {
            int idx = 0;
            Y_meta[idx].add(indices[i]);
        }
        return SuperLabelUtils.convertListArrayTo2DArray(Y_meta);
    }

    public static int[][] generatePartition(int L) {
        int[][] partition = new int[L][];
        for (int j = 0; j < L; ++j) {
            partition[j] = new int[]{j};
        }
        return partition;
    }

    public static int[][] generatePartition(int[] indices, Random r) {
        int L = indices.length;
        return SuperLabelUtils.generatePartition(indices, r.nextInt(L) + 1, r);
    }

    public static int[][] generatePartition(int[] indices, int num, Random r) {
        int[][] partition;
        int i;
        int L = indices.length;
        MLUtils.randomize(indices, r);
        ArrayList[] selection = new ArrayList[num];
        for (i = 0; i < num; ++i) {
            selection[i] = new ArrayList();
            selection[i].add(indices[i]);
        }
        for (i = num; i < L; ++i) {
            int idx = r.nextInt(num);
            selection[idx].add(indices[i]);
        }
        for (int[] part : partition = SuperLabelUtils.convertListArrayTo2DArray(selection)) {
            Arrays.sort(part);
        }
        return partition;
    }

    public static int[][] generatePartition(int[] indices, int num, Random r, boolean balanced) {
        if (!balanced) {
            return SuperLabelUtils.generatePartition(indices, num, r);
        }
        int L = indices.length;
        MLUtils.randomize(indices, r);
        int[][] partition = new int[num][];
        int k = L / num;
        int e = L % num;
        int m = 0;
        for (int c = 0; c < num; ++c) {
            if (c < e) {
                partition[c] = Arrays.copyOfRange(indices, m, m + k + 1);
                m = m + k + 1;
            } else {
                partition[c] = Arrays.copyOfRange(indices, m, Math.min(L, m + k));
                m += k;
            }
            Arrays.sort(partition[c]);
        }
        return partition;
    }

    public static final int[][] getPartitionFromDatasetHierarchy(Instances D) {
        HashMap<String, LabelSet> map = new HashMap<String, LabelSet>();
        int L = D.classIndex();
        for (int j = 0; j < L; ++j) {
            String s = D.attribute(j).name().split("\\.")[0];
            LabelSet Y = (LabelSet)map.get(s);
            if (Y == null) {
                Y = new LabelSet(new int[]{j});
            } else {
                Y.indices = A.append(Y.indices, j);
                Arrays.sort(Y.indices);
            }
            map.put(s, Y);
        }
        int[][] partition = new int[map.size()][];
        int i = 0;
        for (LabelSet part : map.values()) {
            partition[i++] = part.indices;
        }
        return partition;
    }

    private static final int[][] convertListArrayTo2DArray(ArrayList<Integer>[] listArray) {
        int num_partitions = listArray.length;
        int[][] array = new int[num_partitions][];
        for (int i = 0; i < listArray.length; ++i) {
            array[i] = A.toPrimitive(listArray[i]);
        }
        return array;
    }

    public static String toString(int[][] partition) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < partition.length; ++i) {
            sb.append(" " + Arrays.toString(partition[i]));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static Instances makePartitionDataset(Instances D, int[] part) throws Exception {
        return SuperLabelUtils.makePartitionDataset(D, part, 0, 0);
    }

    public static Instances makePartitionDataset(Instances D, int[] part, int P, int N) throws Exception {
        int L = D.classIndex();
        Instances D_ = new Instances(D);
        D_.setClassIndex(-1);
        D_ = F.keepLabels(D, L, part);
        D_.setClassIndex(part.length);
        D_ = PSUtils.PSTransformation(D_, P, N);
        return D_;
    }
}

