/*
 * Decompiled with CFR 0.152.
 */
package meka.experiment;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.DefaultListModel;
import meka.classifiers.multilabel.BCC;
import meka.classifiers.multilabel.BR;
import meka.experiment.MekaClassifierSplitEvaluator;
import meka.experiment.MekaCrossValidationSplitResultProducer;
import meka.experiment.MekaExperiment;
import meka.experiment.MekaRandomSplitResultProducer;
import meka.gui.goe.GenericObjectEditor;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.Range;
import weka.experiment.InstancesResultListener;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.PropertyNode;
import weka.experiment.ResultListener;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class Example {
    public static void randomSplit(File[] files, String key) throws Exception {
        System.out.println("Configuring random split...");
        MekaExperiment exp = new MekaExperiment();
        DefaultListModel<File> datasets = new DefaultListModel<File>();
        for (File file : files) {
            datasets.addElement(file);
        }
        exp.setDatasets(datasets);
        MekaClassifierSplitEvaluator se = new MekaClassifierSplitEvaluator();
        Classifier sec = se.getClassifier();
        MekaRandomSplitResultProducer rsrp = new MekaRandomSplitResultProducer();
        rsrp.setRandomizeData(true);
        rsrp.setTrainPercent(66.0);
        rsrp.setSplitEvaluator(se);
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", MekaRandomSplitResultProducer.class), MekaRandomSplitResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        exp.setResultProducer(rsrp);
        exp.setPropertyPath(propertyPath);
        exp.setRunLower(1);
        exp.setRunUpper(10);
        exp.setPropertyArray(new Classifier[]{new BR(), new BCC()});
        InstancesResultListener irl = new InstancesResultListener();
        File outfile = new File(System.getProperty("java.io.tmpdir") + File.separator + "meka_rs.arff");
        System.out.println("Storing results in: " + outfile);
        irl.setOutputFile(outfile);
        exp.setResultListener((ResultListener)irl);
        System.out.println("Initializing...");
        exp.initialize();
        System.out.println("Running...");
        exp.runExperiment();
        System.out.println("Finishing...");
        exp.postProcess();
        System.out.println("Evaluating...");
        PairedCorrectedTTester tester = new PairedCorrectedTTester();
        Instances result = new Instances((Reader)new BufferedReader(new FileReader(irl.getOutputFile())));
        tester.setInstances(result);
        tester.setSortColumn(-1);
        tester.setRunColumn(result.attribute("Key_Run").index());
        tester.setResultsetKeyColumns(new Range("" + (result.attribute("Key_Dataset").index() + 1)));
        tester.setDatasetKeyColumns(new Range("" + (result.attribute("Key_Scheme").index() + 1) + "," + (result.attribute("Key_Scheme_options").index() + 1) + "," + (result.attribute("Key_Scheme_version_ID").index() + 1)));
        tester.setResultMatrix((ResultMatrix)new ResultMatrixPlainText());
        tester.setDisplayedResultsets(null);
        tester.setSignificanceLevel(0.05);
        tester.setShowStdDevs(true);
        tester.multiResultsetFull(0, result.attribute(key).index());
        System.out.println("\nResult:");
        int compareCol = result.attribute(key).index();
        System.out.println(tester.header(compareCol));
        System.out.println(tester.multiResultsetFull(0, compareCol));
    }

    public static void crossValidation(File[] files, String key) throws Exception {
        System.out.println("Configuring cross-validation...");
        MekaExperiment exp = new MekaExperiment();
        DefaultListModel<File> datasets = new DefaultListModel<File>();
        for (File file : files) {
            datasets.addElement(file);
        }
        exp.setDatasets(datasets);
        MekaClassifierSplitEvaluator se = new MekaClassifierSplitEvaluator();
        Classifier sec = se.getClassifier();
        MekaCrossValidationSplitResultProducer cvrp = new MekaCrossValidationSplitResultProducer();
        cvrp.setNumFolds(10);
        cvrp.setSplitEvaluator(se);
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", MekaCrossValidationSplitResultProducer.class), MekaCrossValidationSplitResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        exp.setResultProducer(cvrp);
        exp.setPropertyPath(propertyPath);
        exp.setRunLower(1);
        exp.setRunUpper(10);
        exp.setPropertyArray(new Classifier[]{new BR(), new BCC()});
        InstancesResultListener irl = new InstancesResultListener();
        File outfile = new File(System.getProperty("java.io.tmpdir") + File.separator + "meka_cv.arff");
        System.out.println("Storing results in: " + outfile);
        irl.setOutputFile(outfile);
        exp.setResultListener((ResultListener)irl);
        System.out.println("Initializing...");
        exp.initialize();
        System.out.println("Running...");
        exp.runExperiment();
        System.out.println("Finishing...");
        exp.postProcess();
        System.out.println("Evaluating...");
        PairedCorrectedTTester tester = new PairedCorrectedTTester();
        Instances result = new Instances((Reader)new BufferedReader(new FileReader(irl.getOutputFile())));
        tester.setInstances(result);
        tester.setSortColumn(-1);
        tester.setRunColumn(result.attribute("Key_Run").index());
        tester.setFoldColumn(result.attribute("Key_Fold").index());
        tester.setResultsetKeyColumns(new Range("" + (result.attribute("Key_Dataset").index() + 1)));
        tester.setDatasetKeyColumns(new Range("" + (result.attribute("Key_Scheme").index() + 1) + "," + (result.attribute("Key_Scheme_options").index() + 1) + "," + (result.attribute("Key_Scheme_version_ID").index() + 1)));
        tester.setResultMatrix((ResultMatrix)new ResultMatrixPlainText());
        tester.setDisplayedResultsets(null);
        tester.setSignificanceLevel(0.05);
        tester.setShowStdDevs(true);
        tester.multiResultsetFull(0, result.attribute(key).index());
        System.out.println("\nResult:");
        int compareCol = result.attribute(key).index();
        System.out.println(tester.header(compareCol));
        System.out.println(tester.multiResultsetFull(0, compareCol));
    }

    public static void main(String[] args) throws Exception {
        GenericObjectEditor.registerAllEditors();
        if (args.length < 2) {
            throw new IllegalArgumentException("Insufficient parameters!\nRequired: <statskey> dataset1 [dataset2, ...]\nExample: Accuracy /some/where/Music.arff");
        }
        String key = args[0];
        File[] files = new File[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            files[i - 1] = new File(args[i]);
        }
        Example.randomSplit(files, key);
        Example.crossValidation(files, key);
    }
}

