/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.explorer;

import javax.swing.SwingUtilities;
import meka.gui.explorer.AbstractExplorerTab;
import meka.gui.explorer.Explorer;

public abstract class AbstractThreadedExplorerTab
extends AbstractExplorerTab {
    private static final long serialVersionUID = -1827939348802826100L;
    protected WorkerThread m_Task;

    public AbstractThreadedExplorerTab(Explorer owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Task = null;
    }

    public boolean isRunning() {
        return this.m_Task != null;
    }

    protected void start(Runnable run) {
        this.m_Task = new WorkerThread(this, run);
        this.m_Task.start();
    }

    public void stop() {
        if (this.m_Task != null) {
            this.m_Task.stop();
        }
    }

    protected abstract void executionStarted();

    protected abstract void executionFinished(Throwable var1);

    protected void executionFinalized() {
        this.m_Task = null;
    }

    public static class WorkerThread
    extends Thread {
        protected AbstractThreadedExplorerTab m_Owner;

        public WorkerThread(AbstractThreadedExplorerTab owner, Runnable run) {
            super(run);
            this.m_Owner = owner;
        }

        public AbstractThreadedExplorerTab getOwner() {
            return this.m_Owner;
        }

        @Override
        public void run() {
            Runnable r;
            try {
                r = new Runnable(){

                    @Override
                    public void run() {
                        WorkerThread.this.m_Owner.executionStarted();
                    }
                };
                SwingUtilities.invokeLater(r);
                super.run();
            }
            catch (Throwable t) {
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        if (t instanceof ThreadDeath) {
                            WorkerThread.this.m_Owner.executionFinished(null);
                        } else {
                            WorkerThread.this.m_Owner.executionFinished(t);
                        }
                        WorkerThread.this.m_Owner.executionFinalized();
                    }
                };
                SwingUtilities.invokeLater(r2);
                return;
            }
            r = new Runnable(){

                @Override
                public void run() {
                    WorkerThread.this.m_Owner.executionFinished(null);
                    WorkerThread.this.m_Owner.executionFinalized();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }
}

