/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import meka.core.MLUtils;
import meka.gui.core.FileChooserBookmarksPanel;
import meka.gui.core.GUIHelper;
import meka.gui.core.MekaPanel;
import meka.gui.core.StatusBar;
import meka.gui.explorer.AbstractExplorerTab;
import meka.gui.explorer.ClassifyTab;
import meka.gui.explorer.PreprocessTab;
import meka.gui.explorer.VisualizeTab;
import meka.gui.goe.GenericObjectEditor;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.SerializedInstancesLoader;
import weka.gui.BrowserHelper;
import weka.gui.ConverterFileChooser;
import weka.gui.ViewerDialog;

public class Explorer
extends MekaPanel {
    private static final long serialVersionUID = 8958333625051395461L;
    protected JTabbedPane m_TabbedPane;
    protected ArrayList<AbstractExplorerTab> m_Tabs;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditData;
    protected JMenuItem m_MenuItemFileHomepage;
    protected Instances m_Data;
    protected File m_CurrentFile;
    protected ConverterFileChooser m_FileChooser;
    protected FileChooserBookmarksPanel m_PanelBookmarks;
    protected ArrayList<File> m_Undo;
    protected StatusBar m_StatusBar;

    @Override
    protected void initialize() {
        this.m_Data = null;
        this.m_CurrentFile = null;
        this.m_MenuBar = null;
        this.m_Tabs = new ArrayList();
        this.m_FileChooser = new ConverterFileChooser(System.getProperty("user.home"));
        this.m_PanelBookmarks = new FileChooserBookmarksPanel();
        this.m_PanelBookmarks.setOwner((JFileChooser)this.m_FileChooser);
        this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
        this.m_FileChooser.setAccessory((JComponent)((Object)this.m_PanelBookmarks));
        this.m_Undo = new ArrayList();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TabbedPane = new JTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        this.m_Tabs.add(new PreprocessTab(this));
        this.m_Tabs.add(new ClassifyTab(this));
        this.m_Tabs.add(new VisualizeTab(this));
        for (AbstractExplorerTab tab : this.m_Tabs) {
            this.m_TabbedPane.addTab(tab.getTitle(), tab);
        }
        this.m_StatusBar = new StatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    @Override
    protected void finishInit() {
        this.m_TabbedPane.setSelectedIndex(0);
        for (AbstractExplorerTab tab : this.m_Tabs) {
            tab.update();
        }
        this.updateMenu();
    }

    public void notifyTabsDataChanged(AbstractExplorerTab source, Instances data) {
        this.m_Data = data;
        for (AbstractExplorerTab tab : this.m_Tabs) {
            if (source != null && tab == source) continue;
            tab.setData(data);
        }
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Explorer.this.updateMenu();
                }
            });
            result.add(menu);
            JMenuItem menuitem = new JMenuItem("Open...", GUIHelper.getIcon("open.gif"));
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(KeyStroke.getKeyStroke("ctrl pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.open();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileOpen = menuitem;
            menuitem = new JMenuItem("Save", GUIHelper.getIcon("save.gif"));
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(KeyStroke.getKeyStroke("ctrl pressed S"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.save();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileSave = menuitem;
            menuitem = new JMenuItem("Save as...", GUIHelper.getEmptyIcon());
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(KeyStroke.getKeyStroke("ctrl shift pressed S"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.saveAs();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close", GUIHelper.getIcon("exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(KeyStroke.getKeyStroke("ctrl pressed Q"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.close();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemFileClose = menuitem;
            menu = new JMenu("Edit");
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Explorer.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Undo", GUIHelper.getIcon("undo.gif"));
            menuitem.setMnemonic('U');
            menuitem.setAccelerator(KeyStroke.getKeyStroke("ctrl pressed Z"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.undo();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Data", GUIHelper.getIcon("report.gif"));
            menuitem.setMnemonic('D');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.edit();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditData = menuitem;
            menu = new JMenu("Help");
            menu.setMnemonic('H');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Explorer.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Homepage", GUIHelper.getIcon("homepage.png"));
            menuitem.setMnemonic('H');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Explorer.this.openHomepage();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileHomepage = menuitem;
            this.m_MenuBar = result;
        }
        result = this.m_MenuBar;
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileOpen.setEnabled(true);
        this.m_MenuItemFileSave.setEnabled(this.m_CurrentFile != null && this.m_Data != null);
        this.m_MenuItemFileSaveAs.setEnabled(this.m_Data != null);
        this.m_MenuItemFileClose.setEnabled(true);
        this.m_MenuItemEditUndo.setEnabled(this.canUndo());
        this.m_MenuItemEditData.setEnabled(this.m_Data != null);
        this.m_MenuItemFileHomepage.setEnabled(true);
    }

    public StatusBar getStatusBar() {
        return this.m_StatusBar;
    }

    public void open(File file, AbstractFileLoader loader) {
        try {
            this.addUndoPoint();
            loader.setFile(file);
            Instances data = loader.getDataSet();
            this.m_CurrentFile = file;
            MLUtils.prepareData(data);
            this.notifyTabsDataChanged(null, data);
        }
        catch (Exception e) {
            System.err.println("Failed to load data from '" + file + "':");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to load dataset from '" + file + "':\n" + e, "Error loading", 0);
        }
        this.updateMenu();
    }

    public void open() {
        int retVal = this.m_FileChooser.showOpenDialog((Component)this);
        if (retVal != 0) {
            return;
        }
        this.open(this.m_FileChooser.getSelectedFile(), this.m_FileChooser.getLoader());
    }

    public void save(File file, AbstractFileSaver saver) {
        if (saver == null) {
            saver = ConverterUtils.getSaverForFile((File)file);
        }
        try {
            saver.setFile(file);
            saver.setInstances(this.m_Data);
            saver.writeBatch();
            this.m_CurrentFile = file;
        }
        catch (Exception e) {
            System.err.println("Failed to save data to '" + file + "':");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to save dataset to '" + file + "':\n" + e, "Error saving", 0);
        }
        this.updateMenu();
    }

    public void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
            return;
        }
        this.save(this.m_CurrentFile, null);
    }

    public void saveAs() {
        this.m_FileChooser.setSelectedFile(this.m_CurrentFile);
        int retVal = this.m_FileChooser.showSaveDialog((Component)this);
        if (retVal != 0) {
            return;
        }
        this.save(this.m_FileChooser.getSelectedFile(), this.m_FileChooser.getSaver());
    }

    public void close() {
        this.closeParent();
    }

    public void edit() {
        Instances copy = new Instances(this.m_Data);
        ViewerDialog dialog = new ViewerDialog(null);
        dialog.setSize(800, 600);
        dialog.setLocationRelativeTo((Component)this);
        int result = dialog.showDialog(copy);
        if (result == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Instances newInstances = dialog.getInstances();
            if (this.m_Data.classIndex() < 0) {
                newInstances.setClassIndex(-1);
            }
            this.notifyTabsDataChanged(null, newInstances);
        }
    }

    public boolean addUndoPoint() {
        boolean result;
        if (this.m_Data == null) {
            return false;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("meka", SerializedInstancesLoader.FILE_EXTENSION);
            tempFile.deleteOnExit();
            ArrayList<File> data = new ArrayList<File>();
            data.add(this.m_CurrentFile);
            data.add((File)this.m_Data);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            oos.writeObject(data);
            oos.flush();
            oos.close();
            this.m_Undo.add(tempFile);
            result = true;
        }
        catch (Exception e) {
            result = false;
            System.err.println("Failed to save undo data to '" + tempFile + "':");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to save undo data to '" + tempFile + "':\n" + e, "Error", 0);
        }
        this.updateMenu();
        return result;
    }

    public boolean canUndo() {
        return this.m_Undo.size() > 0;
    }

    public void undo() {
        if (this.m_Undo.size() == 0) {
            return;
        }
        File file = this.m_Undo.get(this.m_Undo.size() - 1);
        this.m_Undo.remove(this.m_Undo.size() - 1);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            ArrayList data = (ArrayList)ois.readObject();
            this.m_CurrentFile = (File)data.get(0);
            Instances inst = (Instances)data.get(1);
            this.notifyTabsDataChanged(null, inst);
        }
        catch (Exception e) {
            System.err.println("Failed to load undo data from '" + file + "':");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to load undo data from '" + file + "':\n" + e, "Undo", 0);
        }
        this.updateMenu();
    }

    public void openHomepage() {
        BrowserHelper.openURL((String)"http://meka.sourceforge.net/");
    }

    public static void main(String[] args) throws Exception {
        GenericObjectEditor.registerAllEditors();
        Explorer main = new Explorer();
        JFrame frame = new JFrame();
        frame.setTitle("MEKA Explorer");
        frame.setDefaultCloseOperation(3);
        frame.setIconImage(GUIHelper.getLogoIcon().getImage());
        frame.setLayout(new BorderLayout());
        frame.add((Component)main, "Center");
        frame.setJMenuBar(main.getMenuBar());
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        if (args.length > 0) {
            main.open(new File(args[0]), ConverterUtils.getLoaderForFile((String)args[0]));
        }
    }
}

