/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class FindBoundingQuadrilateral {
    public static List<Point2D_F64> findCorners(List<Point2D_F64> list) {
        Point2D_F64 corner0 = list.get(UtilCalibrationGrid.findFarthest(list.get(0), list));
        Point2D_F64 corner1 = list.get(UtilCalibrationGrid.findFarthest(corner0, list));
        Point2D_F64 corner2 = FindBoundingQuadrilateral.maximizeArea(corner0, corner1, list);
        Point2D_F64 corner3 = FindBoundingQuadrilateral.maximizeForth(corner0, corner2, corner1, list);
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        ret.add(corner0);
        ret.add(corner1);
        ret.add(corner2);
        ret.add(corner3);
        Point2D_F64 center = UtilPoint2D_F64.mean(ret, null);
        UtilCalibrationGrid.sortByAngleCCW(center, ret);
        return ret;
    }

    public static Point2D_F64 maximizeArea(Point2D_F64 a, Point2D_F64 b, List<Point2D_F64> list) {
        double max = 0.0;
        Point2D_F64 maxPoint = null;
        for (Point2D_F64 c : list) {
            double area = FindBoundingQuadrilateral.area(a, b, c);
            if (!(area > max)) continue;
            max = area;
            maxPoint = c;
        }
        return maxPoint;
    }

    public static Point2D_F64 maximizeForth(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, List<Point2D_F64> list) {
        double max = 0.0;
        Point2D_F64 maxPoint = null;
        for (Point2D_F64 d : list) {
            double l3;
            double l2;
            double l1 = a.distance((GeoTuple2D_F64)d);
            double score = l1 + (l2 = b.distance((GeoTuple2D_F64)d)) + (l3 = c.distance((GeoTuple2D_F64)d));
            if (!(score > max)) continue;
            max = score;
            maxPoint = d;
        }
        return maxPoint;
    }

    public static double area(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        double top = a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
        return Math.abs(top) / 2.0;
    }
}

