/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.blob.BlobContainer;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;

public class BinaryFileWriter
extends AbstractRatOutput
implements FileWriter {
    private static final long serialVersionUID = 5871927859523743161L;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Writes incoming binary data (byte array or " + BlobContainer.class.getName() + ") to a binary file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "outputFile", (Object)this.getDefaultOutputFile());
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile(".");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile);
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{byte[].class, BlobContainer.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doTransmit() {
        String result;
        FilterOutputStream out = null;
        try {
            result = null;
            byte[] content = this.m_Input instanceof BlobContainer ? (byte[])((BlobContainer)this.m_Input).getContent() : (byte[])this.m_Input;
            out = new BufferedOutputStream(new FileOutputStream(this.m_OutputFile.getAbsolutePath()));
            out.write(content);
            ((BufferedOutputStream)out).flush();
        }
        catch (Exception e) {
            result = this.handleException("Failed to write byte array to " + this.m_OutputFile, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

