/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.flow.core.Unknown;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.standalone.rats.output.RatOutput;

public class Branch
extends AbstractRatOutput {
    private static final long serialVersionUID = -3300963022239958581L;
    protected RatOutput[] m_Outputs;

    public String globalInfo() {
        return "Forwards the input data to all defined sub-outputs ('sub-branches').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "outputs", (Object)new RatOutput[0]);
    }

    @Override
    public void setOwner(Rat value) {
        super.setOwner(value);
        for (RatOutput output : this.m_Outputs) {
            output.setOwner(this.getOwner());
        }
    }

    public void setOutputs(RatOutput[] value) {
        for (RatOutput output : this.m_Outputs = value) {
            output.setOwner(this.getOwner());
        }
        this.reset();
    }

    public RatOutput[] getOutputs() {
        return this.m_Outputs;
    }

    public String outputsTipText() {
        return "The transmitters to send the data to.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            for (int i = 0; i < this.m_Outputs.length; ++i) {
                result = this.m_Outputs[i].setUp();
                if (result == null) continue;
                result = "Output #" + (i + 1) + ": ";
                break;
            }
        }
        return result;
    }

    @Override
    protected String doTransmit() {
        String result = null;
        for (int i = 0; i < this.m_Outputs.length; ++i) {
            this.m_Outputs[i].input(this.m_Input);
            result = this.m_Outputs[i].transmit();
            if (result == null) continue;
            result = "Output #" + (i + 1) + " failed with transmitting: " + result;
            break;
        }
        return result;
    }
}

