/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Attachable;
import org.jooq.Converter;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.Row;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.InvalidResultException;
import org.jooq.exception.MappingException;
import org.jooq.impl.AbstractStore;
import org.jooq.impl.DefaultRecordMapper;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Utils;
import org.jooq.impl.Value;
import org.jooq.tools.Convert;

abstract class AbstractRecord
extends AbstractStore
implements Record {
    private static final long serialVersionUID = -6052512608911220404L;
    final RowImpl fields;
    final Value<?>[] values;

    AbstractRecord(Collection<? extends Field<?>> fields) {
        this(new RowImpl(fields));
    }

    AbstractRecord(Field<?> ... fields) {
        this(new RowImpl(fields));
    }

    AbstractRecord(RowImpl fields) {
        this.fields = fields;
        this.values = new Value[fields.size()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new Value<Object>(null);
        }
    }

    @Override
    final List<Attachable> getAttachables() {
        ArrayList<Attachable> result = new ArrayList<Attachable>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object value = this.getValue0(i).getValue();
            if (!(value instanceof Attachable)) continue;
            result.add((Attachable)value);
        }
        return result;
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.fieldsRow().field(field);
    }

    @Override
    public final Field<?> field(String name) {
        return this.fieldsRow().field(name);
    }

    @Override
    public final Field<?> field(int index) {
        return index >= 0 && index < this.fields.size() ? this.fields.field(index) : null;
    }

    @Override
    public final Field<?>[] fields() {
        return this.fields.fields();
    }

    @Override
    public final Field<?>[] fields(Field<?> ... f) {
        return this.fields.fields(f);
    }

    @Override
    public final Field<?>[] fields(String ... fieldNames) {
        return this.fields.fields(fieldNames);
    }

    @Override
    public final Field<?>[] fields(int ... fieldIndexes) {
        return this.fields.fields(fieldIndexes);
    }

    @Override
    public final int size() {
        return this.fields.size();
    }

    @Override
    public final <T> T getValue(Field<T> field) {
        return this.getValue0(field).getValue();
    }

    @Override
    public final <T> T getValue(Field<T> field, T defaultValue) {
        return this.getValue0(field).getValue(defaultValue);
    }

    @Override
    public final <T> T getValue(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.getValue(field), type);
    }

    @Override
    public final <T> T getValue(Field<?> field, Class<? extends T> type, T defaultValue) {
        T result = this.getValue(field, type);
        return result == null ? defaultValue : result;
    }

    @Override
    public final <T, U> U getValue(Field<T> field, Converter<? super T, U> converter) {
        return converter.from(this.getValue(field));
    }

    @Override
    public final <T, U> U getValue(Field<T> field, Converter<? super T, U> converter, U defaultValue) {
        U result = this.getValue(field, converter);
        return result == null ? defaultValue : result;
    }

    @Override
    public final Object getValue(int index) {
        return this.getValue0(index).getValue();
    }

    @Override
    public final Object getValue(int index, Object defaultValue) {
        Object result = this.getValue(index);
        return result == null ? defaultValue : result;
    }

    @Override
    public final <T> T getValue(int index, Class<? extends T> type) {
        return Convert.convert(this.getValue(index), type);
    }

    @Override
    public final <T> T getValue(int index, Class<? extends T> type, T defaultValue) {
        T result = this.getValue(index, type);
        return result == null ? defaultValue : result;
    }

    @Override
    public final <U> U getValue(int index, Converter<?, U> converter) {
        return Convert.convert(this.getValue(index), converter);
    }

    @Override
    public final <U> U getValue(int index, Converter<?, U> converter, U defaultValue) {
        U result = this.getValue(index, converter);
        return result == null ? defaultValue : result;
    }

    @Override
    public final Object getValue(String fieldName) {
        return this.getValue(this.field(fieldName));
    }

    @Override
    public final Object getValue(String fieldName, Object defaultValue) {
        return this.getValue(this.field(fieldName), defaultValue);
    }

    @Override
    public final <T> T getValue(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.getValue(fieldName), type);
    }

    @Override
    public final <T> T getValue(String fieldName, Class<? extends T> type, T defaultValue) {
        T result = this.getValue(fieldName, type);
        return result == null ? defaultValue : result;
    }

    @Override
    public final <U> U getValue(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.getValue(fieldName), converter);
    }

    @Override
    public final <U> U getValue(String fieldName, Converter<?, U> converter, U defaultValue) {
        U result = this.getValue(fieldName, converter);
        return result == null ? defaultValue : result;
    }

    final <T> Value<T> getValue0(int index) {
        Value<?>[] v = this.getValues();
        if (index >= v.length) {
            throw new IllegalArgumentException("Field " + index + " is not contained in list");
        }
        return v[index];
    }

    final <T> Value<T> getValue0(Field<T> field) {
        return this.getValue0(Utils.indexOrFail(this.fieldsRow(), field));
    }

    final Value<?>[] getValues() {
        return this.values;
    }

    protected final void setValue(int index, Object value) {
        this.setValue(index, this.field(index), value);
    }

    @Override
    public final <T> void setValue(Field<T> field, T value) {
        this.setValue(Utils.indexOrFail((Row)this.fields, field), field, value);
    }

    private final <T> void setValue(int index, Field<T> field, T value) {
        Value<T> val = this.getValue0(index);
        UniqueKey<?> key = this.getPrimaryKey();
        if (key == null || !key.getFields().contains(field)) {
            val.setValue(value);
        } else if (val.isChanged()) {
            val.setValue(value);
        } else if (SettingsTools.updatablePrimaryKeys(Utils.settings(this))) {
            val.setValue(value);
        } else {
            val.setValue(value, true);
            if (val.isChanged()) {
                this.changed(true);
            }
        }
    }

    @Override
    public final <T, U> void setValue(Field<T> field, U value, Converter<T, ? super U> converter) {
        this.setValue(field, converter.to(value));
    }

    final void setValues(Field<?>[] fields, AbstractRecord record) {
        for (Field<?> field : fields) {
            this.setValue(field, record.getValue0(field));
        }
    }

    final void setValue(Field<?> field, Value<?> value) {
        this.setValue(Utils.indexOrFail(this.fieldsRow(), field), value);
    }

    final void setValue(int index, Value<?> value) {
        this.getValues()[index] = value;
    }

    UniqueKey<?> getPrimaryKey() {
        return null;
    }

    @Override
    public Record original() {
        return Utils.newRecord(this.getClass(), this.fields.fields.fields, this.configuration()).operate(new RecordOperation<AbstractRecord, RuntimeException>(){

            @Override
            public AbstractRecord operate(AbstractRecord record) throws RuntimeException {
                Value<?>[] v = AbstractRecord.this.getValues();
                for (int i = 0; i < v.length; ++i) {
                    record.setValue(i, new Value(v[i].getOriginal()));
                }
                return record;
            }
        });
    }

    @Override
    public final <T> T original(Field<T> field) {
        return (T)this.original(Utils.indexOrFail(this.fieldsRow(), field));
    }

    @Override
    public final Object original(int fieldIndex) {
        return this.getValues()[fieldIndex].getOriginal();
    }

    @Override
    public final Object original(String fieldName) {
        return this.original(Utils.indexOrFail(this.fieldsRow(), fieldName));
    }

    @Override
    public final boolean changed() {
        for (Value<?> value : this.getValues()) {
            if (!value.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean changed(Field<?> field) {
        return this.changed(Utils.indexOrFail(this.fieldsRow(), field));
    }

    @Override
    public final boolean changed(int fieldIndex) {
        return this.getValue0(fieldIndex).isChanged();
    }

    @Override
    public final boolean changed(String fieldName) {
        return this.changed(Utils.indexOrFail(this.fieldsRow(), fieldName));
    }

    @Override
    public final void changed(boolean changed) {
        for (Value<?> value : this.getValues()) {
            value.setChanged(changed);
        }
    }

    @Override
    public final void changed(Field<?> field, boolean changed) {
        this.changed(Utils.indexOrFail(this.fieldsRow(), field), changed);
    }

    @Override
    public final void changed(int fieldIndex, boolean changed) {
        this.getValue0(fieldIndex).setChanged(changed);
    }

    @Override
    public final void changed(String fieldName, boolean changed) {
        this.changed(Utils.indexOrFail(this.fieldsRow(), fieldName), changed);
    }

    @Override
    public final void reset() {
        for (Value<?> value : this.getValues()) {
            value.reset();
        }
    }

    @Override
    public final void reset(Field<?> field) {
        this.reset(Utils.indexOrFail(this.fieldsRow(), field));
    }

    @Override
    public final void reset(int fieldIndex) {
        this.getValue0(fieldIndex).reset();
    }

    @Override
    public final void reset(String fieldName) {
        this.reset(Utils.indexOrFail(this.fieldsRow(), fieldName));
    }

    @Override
    public final Object[] intoArray() {
        return (Object[])this.into((Object)Object[].class);
    }

    @Override
    public final Map<String, Object> intoMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            Field<?> field = this.fields.field(i);
            if (map.put(field.getName(), this.getValue(i)) == null) continue;
            throw new InvalidResultException("Field " + field.getName() + " is not unique in Record : " + this);
        }
        return map;
    }

    @Override
    public final <E> E into(Class<? extends E> type) {
        return Utils.configuration(this).recordMapperProvider().provide(this.fields.fields, type).map(this);
    }

    @Override
    public final <E> E into(E object) {
        if (object == null) {
            throw new NullPointerException("Cannot copy Record into null");
        }
        Class<?> type = object.getClass();
        try {
            return (E)new DefaultRecordMapper(this.fields.fields, type, object).map(this);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("An error ocurred when mapping record to " + type, e);
        }
    }

    @Override
    public final <R extends Record> R into(final Table<R> table) {
        return Utils.newRecord(table, this.configuration()).operate(new RecordOperation<R, MappingException>(){

            @Override
            public R operate(R record) throws MappingException {
                try {
                    UniqueKey<?> key;
                    for (Field<?> field : table.fields()) {
                        Field<?> sourceField = AbstractRecord.this.field(field);
                        if (sourceField == null) continue;
                        Utils.setValue(record, field, AbstractRecord.this, sourceField);
                    }
                    if (record instanceof AbstractRecord && (key = ((AbstractRecord)record).getPrimaryKey()) != null) {
                        boolean isKeySet = true;
                        for (Field field : key.getFields()) {
                            isKeySet = isKeySet && AbstractRecord.this.field(field) != null;
                        }
                        if (isKeySet) {
                            record.changed(false);
                        }
                    }
                    return record;
                }
                catch (Exception e) {
                    throw new MappingException("An error ocurred when mapping record to " + table, e);
                }
            }
        });
    }

    @Override
    public final ResultSet intoResultSet() {
        ResultImpl<AbstractRecord> result = new ResultImpl<AbstractRecord>(this.configuration(), this.fields.fields.fields);
        result.add(this);
        return result.intoResultSet();
    }

    @Override
    public final <E> E map(RecordMapper<Record, E> mapper) {
        return mapper.map(this);
    }

    @Override
    public final void from(Object source) {
        if (source == null) {
            return;
        }
        if (source instanceof Map) {
            this.fromMap((Map)source);
        } else if (source instanceof Object[]) {
            this.fromArray((Object[])source);
        } else {
            this.from(source, this.fields());
        }
    }

    @Override
    public final void from(Object source, Field<?> ... f) {
        if (source == null) {
            return;
        }
        if (source instanceof Map) {
            this.fromMap((Map)source, f);
        } else if (source instanceof Object[]) {
            this.fromArray((Object[])source, f);
        } else {
            Class<?> type = source.getClass();
            try {
                boolean useAnnotations = Utils.hasColumnAnnotations(type);
                for (Field<?> field : f) {
                    Method method;
                    List<java.lang.reflect.Field> members;
                    if (useAnnotations) {
                        members = Utils.getAnnotatedMembers(type, field.getName());
                        method = Utils.getAnnotatedGetter(type, field.getName());
                    } else {
                        members = Utils.getMatchingMembers(type, field.getName());
                        method = Utils.getMatchingGetter(type, field.getName());
                    }
                    if (method != null) {
                        Utils.setValue(this, field, method.invoke(source, new Object[0]));
                        continue;
                    }
                    if (members.size() <= 0) continue;
                    this.from(source, members.get(0), field);
                }
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record from " + type, e);
            }
        }
    }

    @Override
    public final void from(Object source, String ... fieldNames) {
        this.from(source, this.fields(fieldNames));
    }

    @Override
    public final void from(Object source, int ... fieldIndexes) {
        this.from(source, this.fields(fieldIndexes));
    }

    @Override
    public final void fromMap(Map<String, ?> map) {
        this.from(map, this.fields());
    }

    @Override
    public final void fromMap(Map<String, ?> map, Field<?> ... f) {
        for (int i = 0; i < f.length; ++i) {
            String name = f[i].getName();
            if (!map.containsKey(name)) continue;
            Utils.setValue(this, f[i], map.get(name));
        }
    }

    @Override
    public final void fromMap(Map<String, ?> map, String ... fieldNames) {
        this.fromMap(map, this.fields(fieldNames));
    }

    @Override
    public final void fromMap(Map<String, ?> map, int ... fieldIndexes) {
        this.fromMap(map, this.fields(fieldIndexes));
    }

    @Override
    public final void fromArray(Object ... array) {
        this.fromArray(array, this.fields());
    }

    @Override
    public final void fromArray(Object[] array, Field<?> ... f) {
        Fields accept = new Fields(f);
        int size = this.fields.size();
        for (int i = 0; i < size && i < array.length; ++i) {
            Field<?> field = this.fields.field(i);
            if (accept.field(field) == null) continue;
            Utils.setValue(this, field, array[i]);
        }
    }

    @Override
    public final void fromArray(Object[] array, String ... fieldNames) {
        this.fromArray(array, this.fields(fieldNames));
    }

    @Override
    public final void fromArray(Object[] array, int ... fieldIndexes) {
        this.fromArray(array, this.fields(fieldIndexes));
    }

    protected final void from(Record source) {
        for (Field<?> field : this.fields.fields.fields) {
            Field<?> sourceField = source.field(field);
            if (sourceField == null) continue;
            Utils.setValue(this, field, source, sourceField);
        }
    }

    private final void from(Object source, java.lang.reflect.Field member, Field<?> field) throws IllegalAccessException {
        Class<?> mType = member.getType();
        if (mType.isPrimitive()) {
            if (mType == Byte.TYPE) {
                Utils.setValue(this, field, member.getByte(source));
            } else if (mType == Short.TYPE) {
                Utils.setValue(this, field, member.getShort(source));
            } else if (mType == Integer.TYPE) {
                Utils.setValue(this, field, member.getInt(source));
            } else if (mType == Long.TYPE) {
                Utils.setValue(this, field, member.getLong(source));
            } else if (mType == Float.TYPE) {
                Utils.setValue(this, field, Float.valueOf(member.getFloat(source)));
            } else if (mType == Double.TYPE) {
                Utils.setValue(this, field, member.getDouble(source));
            } else if (mType == Boolean.TYPE) {
                Utils.setValue(this, field, member.getBoolean(source));
            } else if (mType == Character.TYPE) {
                Utils.setValue(this, field, Character.valueOf(member.getChar(source)));
            }
        } else {
            Utils.setValue(this, field, member.get(source));
        }
    }

    public String toString() {
        ResultImpl result = new ResultImpl(this.configuration(), this.fields.fields.fields);
        result.add(this);
        return ((Object)result).toString();
    }

    @Override
    public int compareTo(Record that) {
        if (that == null) {
            throw new NullPointerException();
        }
        if (this.size() != that.size()) {
            throw new ClassCastException(String.format("Trying to compare incomparable records (wrong degree):\n%s\n%s", this, that));
        }
        Class<?>[] thisTypes = this.fieldsRow().types();
        Class<?>[] thatTypes = that.fieldsRow().types();
        if (!Arrays.asList(thisTypes).equals(Arrays.asList(thatTypes))) {
            throw new ClassCastException(String.format("Trying to compare incomparable records (type mismatch):\n%s\n%s", this, that));
        }
        for (int i = 0; i < this.size(); ++i) {
            int compare;
            Object thisValue = this.getValue(i);
            Object thatValue = that.getValue(i);
            if (thisValue == null && thatValue == null) continue;
            if (thisValue == null) {
                return 1;
            }
            if (thatValue == null) {
                return -1;
            }
            if (thisValue.getClass().isArray() && thatValue.getClass().isArray()) {
                if (thisValue.getClass() == byte[].class) {
                    compare = this.compare((byte[])thisValue, (byte[])thatValue);
                    if (compare == 0) continue;
                    return compare;
                }
                if (!thisValue.getClass().getComponentType().isPrimitive()) {
                    compare = this.compare((Object[])thisValue, (Object[])thatValue);
                    if (compare == 0) continue;
                    return compare;
                }
                throw new ClassCastException(String.format("Unsupported data type in natural ordering: %s", thisValue.getClass()));
            }
            compare = ((Comparable)thisValue).compareTo(thatValue);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    final int compare(byte[] array1, byte[] array2) {
        int length = Math.min(array1.length, array2.length);
        for (int i = 0; i < length; ++i) {
            int v1 = array1[i] & 0xFF;
            int v2 = array2[i] & 0xFF;
            if (v1 == v2) continue;
            return v1 < v2 ? -1 : 1;
        }
        return array1.length - array2.length;
    }

    final int compare(Object[] array1, Object[] array2) {
        int length = Math.min(array1.length, array2.length);
        for (int i = 0; i < length; ++i) {
            int compare = ((Comparable)array1[i]).compareTo(array2[i]);
            if (compare == 0) continue;
            return compare;
        }
        return array1.length - array2.length;
    }
}

