/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.AggregateFunction;
import org.jooq.AttachableInternal;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.ExecuteContext;
import org.jooq.Field;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Routine;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.ParameterImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Utils;
import org.jooq.tools.Convert;

public abstract class AbstractRoutine<T>
extends AbstractQueryPart
implements Routine<T>,
AttachableInternal {
    private static final long serialVersionUID = 6330037113167106443L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_FUNCTION};
    private final Schema schema;
    private final Package pkg;
    private final String name;
    private final List<Parameter<?>> allParameters;
    private final List<Parameter<?>> inParameters;
    private final List<Parameter<?>> outParameters;
    private final DataType<T> type;
    private Parameter<T> returnParameter;
    private boolean overloaded;
    private final Map<Parameter<?>, Field<?>> inValues;
    private final Set<Parameter<?>> inValuesNonDefaulted;
    private transient Field<T> function;
    private Configuration configuration;
    private final Map<Parameter<?>, Object> results;
    private final Map<Parameter<?>, Integer> parameterIndexes = new HashMap();

    protected AbstractRoutine(String name, Schema schema) {
        this(name, schema, null, null);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg) {
        this(name, schema, pkg, null);
    }

    protected AbstractRoutine(String name, Schema schema, DataType<T> type) {
        this(name, schema, null, type);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg, DataType<T> type) {
        this.schema = schema;
        this.pkg = pkg;
        this.name = name;
        this.allParameters = new ArrayList();
        this.inParameters = new ArrayList();
        this.outParameters = new ArrayList();
        this.inValues = new HashMap();
        this.inValuesNonDefaulted = new HashSet();
        this.results = new HashMap();
        this.type = type;
    }

    protected final void setNumber(Parameter<? extends Number> parameter, Number value) {
        this.setValue(parameter, Convert.convert((Object)value, parameter.getType()));
    }

    protected final void setNumber(Parameter<? extends Number> parameter, Field<? extends Number> value) {
        this.setField(parameter, value);
    }

    protected final void setValue(Parameter<?> parameter, Object value) {
        this.setField(parameter, DSL.val(value, parameter.getDataType()));
    }

    protected final void setField(Parameter<?> parameter, Field<?> value) {
        if (value == null) {
            this.setField(parameter, DSL.val(null, parameter.getDataType()));
        } else {
            this.inValues.put(parameter, value);
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int execute(Configuration c) {
        Configuration previous = this.configuration();
        try {
            this.attach(c);
            int n = this.execute();
            return n;
        }
        finally {
            this.attach(previous);
        }
    }

    @Override
    public final int execute() {
        if (this.type == null) {
            return this.executeCallableStatement();
        }
        switch (this.configuration.dialect().family()) {
            case HSQLDB: {
                if (SQLDataType.RESULT.equals(this.type.getSQLDataType())) {
                    return this.executeSelectFrom();
                }
            }
            case H2: {
                return this.executeSelect();
            }
        }
        return this.executeCallableStatement();
    }

    private final int executeSelectFrom() {
        DSLContext create = this.create(this.configuration);
        Result result = create.selectFrom(DSL.table(this.asField())).fetch();
        this.results.put(this.returnParameter, result);
        return 0;
    }

    private final int executeSelect() {
        Field<T> field = this.asField();
        this.results.put(this.returnParameter, this.create(this.configuration).select(field).fetchOne(field));
        return 0;
    }

    private final int executeCallableStatement() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, this);
        ExecuteListeners listener = new ExecuteListeners(ctx);
        try {
            Connection connection = ctx.connection();
            listener.renderStart(ctx);
            ctx.sql(this.create(this.configuration).render(this));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            ctx.statement(connection.prepareCall(ctx.sql()));
            listener.prepareEnd(ctx);
            listener.bindStart(ctx);
            DSL.using(this.configuration).bindContext(ctx.statement()).visit(this);
            this.registerOutParameters(this.configuration, (CallableStatement)ctx.statement());
            listener.bindEnd(ctx);
            listener.executeStart(ctx);
            ctx.statement().execute();
            listener.executeEnd(ctx);
            this.fetchOutParameters(ctx);
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Utils.safeClose(listener, ctx);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final void bind(BindContext context) {
        for (Parameter<?> parameter : this.getParameters()) {
            if (this.getInParameters().contains(parameter) && !this.inValuesNonDefaulted.contains(parameter)) continue;
            int index = context.peekIndex();
            this.parameterIndexes.put(parameter, index);
            if (this.getInValues().get(parameter) != null) {
                context.visit(this.getInValues().get(parameter));
                if (index != context.peekIndex() || !this.getOutParameters().contains(parameter)) continue;
                context.nextIndex();
                continue;
            }
            context.nextIndex();
        }
    }

    @Override
    public final void toSQL(RenderContext context) {
        this.toSQLBegin(context);
        if (this.getReturnParameter() != null) {
            this.toSQLAssign(context);
        }
        this.toSQLCall(context);
        context.sql("(");
        String separator = "";
        for (Parameter<?> parameter : this.getParameters()) {
            if (parameter.equals(this.getReturnParameter())) continue;
            if (this.getOutParameters().contains(parameter)) {
                context.sql(separator);
                this.toSQLOutParam(context, parameter);
            } else {
                if (!this.inValuesNonDefaulted.contains(parameter)) continue;
                Field<?> value = this.getInValues().get(parameter);
                if (SQLDialect.POSTGRES == context.configuration().dialect() && this.isOverloaded()) {
                    value = value.cast(parameter.getType());
                }
                context.sql(separator);
                this.toSQLInParam(context, parameter, value);
            }
            separator = ", ";
        }
        context.sql(")");
        this.toSQLEnd(context);
    }

    private final void toSQLEnd(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            default: 
        }
        context.sql(" }");
    }

    private final void toSQLBegin(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            default: 
        }
        context.sql("{ ");
    }

    private final void toSQLAssign(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            default: 
        }
        context.sql("? = ");
    }

    private final void toSQLCall(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            default: 
        }
        context.sql("call ");
        this.toSQLQualifiedName(context);
    }

    private final void toSQLOutParam(RenderContext context, Parameter<?> parameter) {
        context.sql("?");
    }

    private final void toSQLInParam(RenderContext context, Parameter<?> parameter, Field<?> value) {
        context.visit(value);
    }

    private final void toSQLQualifiedName(RenderContext context) {
        Schema mappedSchema = Utils.getMappedSchema(context.configuration(), this.getSchema());
        if (context.qualify()) {
            if (mappedSchema != null) {
                context.visit(mappedSchema);
                context.sql(".");
            }
            if (this.getPackage() != null) {
                context.visit(this.getPackage());
                context.sql(".");
            }
        }
        context.literal(this.getName());
    }

    private final void fetchOutParameters(ExecuteContext ctx) throws SQLException {
        for (Parameter<?> parameter : this.getParameters()) {
            if (!parameter.equals(this.getReturnParameter()) && !this.getOutParameters().contains(parameter)) continue;
            int index = this.parameterIndexes.get(parameter);
            this.results.put(parameter, Utils.getFromStatement(ctx, parameter.getType(), index));
        }
    }

    private final void registerOutParameters(Configuration c, CallableStatement statement) throws SQLException {
        for (Parameter<?> parameter : this.getParameters()) {
            if (!parameter.equals(this.getReturnParameter()) && !this.getOutParameters().contains(parameter)) continue;
            int index = this.parameterIndexes.get(parameter);
            int sqlType = parameter.getDataType().getDataType(c).getSQLType();
            switch (c.dialect().family()) {
                default: 
            }
            statement.registerOutParameter(index, sqlType);
        }
    }

    @Override
    public final T getReturnValue() {
        if (this.returnParameter != null) {
            return this.getValue(this.returnParameter);
        }
        return null;
    }

    protected final <Z> Z getValue(Parameter<Z> parameter) {
        return (Z)this.results.get(parameter);
    }

    protected final Map<Parameter<?>, Field<?>> getInValues() {
        return this.inValues;
    }

    @Override
    public final List<Parameter<?>> getOutParameters() {
        return Collections.unmodifiableList(this.outParameters);
    }

    @Override
    public final List<Parameter<?>> getInParameters() {
        return Collections.unmodifiableList(this.inParameters);
    }

    @Override
    public final List<Parameter<?>> getParameters() {
        return Collections.unmodifiableList(this.allParameters);
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final Package getPackage() {
        return this.pkg;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final Parameter<?> getReturnParameter() {
        return this.returnParameter;
    }

    protected final void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    protected final boolean isOverloaded() {
        return this.overloaded;
    }

    protected final void addInParameter(Parameter<?> parameter) {
        this.inParameters.add(parameter);
        this.allParameters.add(parameter);
        this.inValues.put(parameter, DSL.val(null, parameter.getDataType()));
        if (!parameter.isDefaulted()) {
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    protected final void addInOutParameter(Parameter<?> parameter) {
        this.addInParameter(parameter);
        this.outParameters.add(parameter);
    }

    protected final void addOutParameter(Parameter<?> parameter) {
        this.outParameters.add(parameter);
        this.allParameters.add(parameter);
    }

    protected final void setReturnParameter(Parameter<T> parameter) {
        this.returnParameter = parameter;
        this.allParameters.add(parameter);
    }

    public final Field<T> asField() {
        if (this.function == null) {
            this.function = new RoutineField();
        }
        return this.function;
    }

    public final Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    public final AggregateFunction<T> asAggregateFunction() {
        Field[] array = new Field[this.getInParameters().size()];
        int i = 0;
        for (Parameter<?> p : this.getInParameters()) {
            array[i] = this.getInValues().get(p);
            ++i;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.schema != null) {
            names.add(this.schema.getName());
        }
        if (this.pkg != null) {
            names.add(this.pkg.getName());
        }
        names.add(this.name);
        return (AggregateFunction)DSL.function(DSL.name(names.toArray(new String[names.size()])), this.type, array);
    }

    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type) {
        return AbstractRoutine.createParameter(name, type, false);
    }

    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted) {
        return new ParameterImpl<T>(name, type, isDefaulted);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    private class RoutineField
    extends AbstractFunction<T> {
        private static final long serialVersionUID = -5730297947647252624L;

        RoutineField() {
            super(AbstractRoutine.this.getName(), AbstractRoutine.this.type, new Field[0]);
        }

        @Override
        final Field<T> getFunction0(Configuration c) {
            RenderContext local = this.create(c).renderContext();
            AbstractRoutine.this.toSQLQualifiedName(local);
            Field[] array = new Field[AbstractRoutine.this.getInParameters().size()];
            int i = 0;
            for (Parameter<?> p : AbstractRoutine.this.getInParameters()) {
                array[i] = SQLDialect.POSTGRES == c.dialect() && AbstractRoutine.this.isOverloaded() ? AbstractRoutine.this.getInValues().get(p).cast(p.getType()) : AbstractRoutine.this.getInValues().get(p);
                ++i;
            }
            return DSL.function(local.render(), this.getDataType(), array);
        }
    }
}

