/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.DSL;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Utils;

class Alias<Q extends QueryPart>
extends AbstractQueryPart {
    private static final long serialVersionUID = -2456848365524191614L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    private final Q wrapped;
    private final String alias;
    private final String[] fieldAliases;
    private final boolean wrapInParentheses;

    Alias(Q wrapped, String alias) {
        this(wrapped, alias, null, false);
    }

    Alias(Q wrapped, String alias, boolean wrapInParentheses) {
        this(wrapped, alias, null, wrapInParentheses);
    }

    Alias(Q wrapped, String alias, String[] fieldAliases) {
        this(wrapped, alias, fieldAliases, false);
    }

    Alias(Q wrapped, String alias, String[] fieldAliases, boolean wrapInParentheses) {
        this.wrapped = wrapped;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    @Override
    public final void toSQL(RenderContext context) {
        if (context.declareFields() || context.declareTables()) {
            SQLDialect dialect = context.configuration().dialect();
            boolean simulateDerivedColumnList = false;
            if (this.fieldAliases != null && Arrays.asList(SQLDialect.CUBRID, SQLDialect.FIREBIRD).contains((Object)dialect.family()) && this.wrapped instanceof TableImpl) {
                SelectJoinStep select = DSL.select(Utils.list(DSL.field("*"))).from(((Table)this.wrapped).as(this.alias));
                ((RenderContext)context.sql("(").formatIndentStart().formatNewLine().visit(select)).formatIndentEnd().formatNewLine().sql(")");
            } else if (this.fieldAliases != null && Arrays.asList(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE).contains((Object)dialect.family())) {
                simulateDerivedColumnList = true;
                SelectFieldList fields = new SelectFieldList();
                for (String fieldAlias : this.fieldAliases) {
                    fields.add(DSL.field("null").as(fieldAlias));
                }
                Select select = DSL.select(fields).where(DSL.falseCondition()).unionAll(DSL.select(DSL.field("*")).from(((Table)this.wrapped).as(this.alias)));
                ((RenderContext)context.sql("(").formatIndentStart().formatNewLine().visit(select)).formatIndentEnd().formatNewLine().sql(")");
            } else {
                this.toSQLWrapped(context);
            }
            Alias.toSQLAs(context);
            context.sql(" ");
            context.literal(this.alias);
            if (this.fieldAliases != null && !simulateDerivedColumnList) {
                this.toSQLDerivedColumnList(context);
            } else {
                switch (dialect) {
                    case HSQLDB: 
                    case POSTGRES: {
                        Q o = this.wrapped;
                        if (!context.declareTables() || !(o instanceof ArrayTable)) break;
                        ArrayTable table = (ArrayTable)o;
                        context.sql("(");
                        Utils.fieldNames(context, table.fields());
                        context.sql(")");
                        break;
                    }
                }
            }
        } else {
            context.literal(this.alias);
        }
    }

    static void toSQLAs(RenderContext context) {
        if (Arrays.asList(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES).contains((Object)context.configuration().dialect())) {
            context.sql(" ").keyword("as");
        }
    }

    private void toSQLWrapped(RenderContext context) {
        ((RenderContext)context.sql(this.wrapInParentheses ? "(" : "").visit((QueryPart)this.wrapped)).sql(this.wrapInParentheses ? ")" : "");
    }

    private void toSQLDerivedColumnList(RenderContext context) {
        String separator = "";
        context.sql("(");
        for (int i = 0; i < this.fieldAliases.length; ++i) {
            context.sql(separator);
            context.literal(this.fieldAliases[i]);
            separator = ", ";
        }
        context.sql(")");
    }

    @Override
    public final void bind(BindContext context) {
        if (context.declareFields() || context.declareTables()) {
            context.visit((QueryPart)this.wrapped);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }
}

