/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.CaseWhenStep;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.Utils;

class CaseWhenStepImpl<V, T>
extends AbstractField<T>
implements CaseWhenStep<V, T> {
    private static final long serialVersionUID = -3817194006479624228L;
    private final Field<V> value;
    private final List<Field<V>> compareValues;
    private final List<Field<T>> results;
    private Field<T> otherwise;

    CaseWhenStepImpl(Field<V> value, Field<V> compareValue, Field<T> result) {
        super("case", result.getDataType());
        this.value = value;
        this.compareValues = new ArrayList<Field<V>>();
        this.results = new ArrayList<Field<T>>();
        this.when(compareValue, result);
    }

    @Override
    public final Field<T> otherwise(T result) {
        return this.otherwise(Utils.field(result));
    }

    @Override
    public final Field<T> otherwise(Field<T> result) {
        this.otherwise = result;
        return this;
    }

    @Override
    public final CaseWhenStep<V, T> when(V compareValue, T result) {
        return this.when(Utils.field(compareValue), Utils.field(result));
    }

    @Override
    public final CaseWhenStep<V, T> when(V compareValue, Field<T> result) {
        return this.when(Utils.field(compareValue), result);
    }

    @Override
    public final CaseWhenStep<V, T> when(Field<V> compareValue, T result) {
        return this.when(compareValue, Utils.field(result));
    }

    @Override
    public final CaseWhenStep<V, T> when(Field<V> compareValue, Field<T> result) {
        this.compareValues.add(compareValue);
        this.results.add(result);
        return this;
    }

    @Override
    public final void bind(BindContext ctx) {
        switch (ctx.configuration().dialect()) {
            case DERBY: {
                for (int i = 0; i < this.compareValues.size(); ++i) {
                    ctx.visit(this.value);
                    ctx.visit(this.compareValues.get(i));
                    ctx.visit(this.results.get(i));
                }
                break;
            }
            default: {
                ctx.visit(this.value);
                for (int i = 0; i < this.compareValues.size(); ++i) {
                    ctx.visit(this.compareValues.get(i));
                    ctx.visit(this.results.get(i));
                }
            }
        }
        if (this.otherwise != null) {
            ctx.visit(this.otherwise);
        }
    }

    @Override
    public final void toSQL(RenderContext ctx) {
        ctx.formatIndentLockStart().keyword("case");
        int size = this.compareValues.size();
        switch (ctx.configuration().dialect()) {
            case DERBY: {
                ctx.formatIndentLockStart();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        ctx.formatNewLine();
                    }
                    ctx.sql(" ").keyword("when").sql(" ");
                    ctx.visit(this.value.equal(this.compareValues.get(i)));
                    ctx.sql(" ").keyword("then").sql(" ");
                    ctx.visit(this.results.get(i));
                }
                break;
            }
            default: {
                ((RenderContext)ctx.sql(" ").visit(this.value)).formatIndentLockStart();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        ctx.formatNewLine();
                    }
                    ctx.sql(" ").keyword("when").sql(" ");
                    ctx.visit(this.compareValues.get(i));
                    ctx.sql(" ").keyword("then").sql(" ");
                    ctx.visit(this.results.get(i));
                }
            }
        }
        if (this.otherwise != null) {
            ctx.formatNewLine().sql(" ").keyword("else").sql(" ").visit(this.otherwise);
        }
        ctx.formatIndentLockEnd();
        if (size > 1 || this.otherwise != null) {
            ctx.formatSeparator();
        } else {
            ctx.sql(" ");
        }
        ctx.keyword("end").formatIndentLockEnd();
    }
}

